/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LineLengthExtendedCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int max = 80;
    private Pattern ignorePattern;
    private String[] lines;
    private boolean ignoreField;
    private boolean ignoreMethod;
    private boolean ignoreConstructor;
    private boolean ignoreClass;

    public LineLengthExtendedCheck() {
        this.setIgnorePattern("^$");
    }

    public void setIgnoreField(boolean value) {
        this.ignoreField = value;
    }

    public void setIgnoreMethod(boolean value) {
        this.ignoreMethod = value;
    }

    public void setIgnoreConstructor(boolean value) {
        this.ignoreConstructor = value;
    }

    public void setIgnoreClass(boolean value) {
        this.ignoreClass = value;
    }

    public int[] getDefaultTokens() {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        if (this.ignoreClass) {
            tokens.add(14);
        }
        if (this.ignoreConstructor) {
            tokens.add(8);
        }
        if (this.ignoreField) {
            tokens.add(10);
        }
        if (this.ignoreMethod) {
            tokens.add(9);
        }
        int[] returnTokens = new int[tokens.size()];
        for (int index = 0; index < tokens.size(); ++index) {
            returnTokens[index] = (Integer)tokens.get(index);
        }
        return returnTokens;
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (ast.getParent().getType() == 6 || ast.getType() == 14) {
            int mNumberOfLine = ast.getLineNo();
            DetailAST endOfIgnoreLine = ast.findFirstToken(7);
            if (endOfIgnoreLine == null) {
                this.lines[mNumberOfLine - 1] = null;
            } else {
                for (int mEndNumberOfLine = endOfIgnoreLine.getLineNo(); mEndNumberOfLine >= mNumberOfLine; --mEndNumberOfLine) {
                    this.lines[mEndNumberOfLine - 1] = null;
                }
            }
        }
    }

    public void beginTree(DetailAST rootAST) {
        this.lines = this.getLines();
    }

    public void finishTree(DetailAST rootAST) {
        for (int i = 0; i < this.lines.length; ++i) {
            String line;
            int realLength;
            if (this.lines[i] == null || (realLength = CommonUtil.lengthExpandedTabs((String)(line = this.lines[i]), (int)line.length(), (int)this.getTabWidth())) <= this.max || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, new Object[]{this.max, realLength});
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public final void setIgnorePattern(String format) {
        try {
            this.ignorePattern = Pattern.compile(format);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("unable to parse " + format, ex);
        }
    }
}

