/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.annotation;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Set;
import java.util.TreeSet;

public class RequiredParameterForAnnotationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "annotation.missing.required.parameter";
    private final Set<String> requiredParameters = new TreeSet<String>();
    private String annotationName;

    public void setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
    }

    public void setRequiredParameters(String ... requiredPropertiesParameter) {
        for (String item : requiredPropertiesParameter) {
            this.requiredParameters.add(item);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public int[] getRequiredTokens() {
        return new int[]{159};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST annotationNode) {
        Sets.SetView missingParameters;
        String annotationNameCheck = RequiredParameterForAnnotationCheck.getAnnotationName(annotationNode);
        if (annotationNameCheck.equals(this.annotationName) && !(missingParameters = Sets.difference(this.requiredParameters, RequiredParameterForAnnotationCheck.getAnnotationParameters(annotationNode))).isEmpty()) {
            String missingParametersAsString = Joiner.on((String)", ").join((Iterable)missingParameters);
            this.log(annotationNode, MSG_KEY, new Object[]{this.annotationName, missingParametersAsString});
        }
    }

    private static String getAnnotationName(DetailAST annotationNode) {
        String result;
        DetailAST identNode = annotationNode.findFirstToken(58);
        if (identNode == null) {
            StringBuilder builder = new StringBuilder();
            DetailAST separationDotNode = annotationNode.findFirstToken(59);
            while (separationDotNode.getType() == 59) {
                builder.insert(0, '.').insert(1, separationDotNode.getLastChild().getText());
                separationDotNode = separationDotNode.getFirstChild();
            }
            builder.insert(0, separationDotNode.getText());
            result = builder.toString();
        } else {
            result = identNode.getText();
        }
        return result;
    }

    private static Set<String> getAnnotationParameters(DetailAST annotationNode) {
        TreeSet<String> annotationParameters = new TreeSet<String>();
        for (DetailAST annotationChildNode = annotationNode.getFirstChild(); annotationChildNode != null; annotationChildNode = annotationChildNode.getNextSibling()) {
            if (annotationChildNode.getType() != 160) continue;
            annotationParameters.add(annotationChildNode.getFirstChild().getText());
        }
        return annotationParameters;
    }
}

