/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@StatelessCheck
public class PreferMethodReferenceCheck
extends AbstractCheck {
    public static final String MSG_METHOD_REF = "method.reference";
    private static final List<Integer> EXCLUDED_STATEMENTS_TOKEN_TYPES = Arrays.asList(38, 85, 91, 83, 88, 89, 90, 95, 84);
    private static final List<Integer> LITERAL_CALL_ARGS = Arrays.asList(79, 78, 139);
    private boolean detectForExpression;

    public void setDetectForExpression(boolean detectForExpression) {
        this.detectForExpression = detectForExpression;
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{181};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getParent().getType() != 208) {
            List<String> args = PreferMethodReferenceCheck.getLambdaArgs(ast);
            DetailAST expr = ast.getLastChild();
            boolean hasViolation = this.checkExpr(expr, args);
            if (hasViolation) {
                this.log(ast, MSG_METHOD_REF, new Object[0]);
            }
        }
    }

    private static List<String> getLambdaArgs(DetailAST ast) {
        ArrayList<String> result = new ArrayList<String>();
        if (ast.getFirstChild().getType() == 58) {
            result.add(ast.getFirstChild().getText());
        } else {
            DetailAST params = ast.findFirstToken(20);
            TokenUtil.forEachChild((DetailAST)params, (int)21, node -> result.add(node.findFirstToken(58).getText()));
        }
        return result;
    }

    private boolean checkExpr(DetailAST expr, List<String> args) {
        boolean result;
        DetailAST child = expr.getFirstChild();
        switch (child.getType()) {
            case 27: {
                result = this.checkMethodCall(child, args);
                break;
            }
            case 136: {
                result = PreferMethodReferenceCheck.matchesCtorArgs(child, args) || PreferMethodReferenceCheck.matchesArrayInitializer(child, args);
                break;
            }
            case 7: 
            case 88: {
                result = child.getFirstChild().getType() != 45 && this.checkExpr(child.getFirstChild(), args);
                break;
            }
            default: {
                result = PreferMethodReferenceCheck.shouldCheck(expr) && this.checkExpr(expr.findFirstToken(28), args);
            }
        }
        return result;
    }

    private boolean checkMethodCall(DetailAST ast, List<String> args) {
        DetailAST elist = ast.findFirstToken(34);
        boolean matchesMethodArgs = PreferMethodReferenceCheck.hasSameArgs(args, elist) && this.isArgsMatch(ast, args);
        boolean matchesFirstArgCall = !args.isEmpty() && PreferMethodReferenceCheck.isCallOnArg(ast, args.get(0)) && PreferMethodReferenceCheck.hasSameArgs(args.subList(1, args.size()), elist);
        return matchesMethodArgs || matchesFirstArgCall;
    }

    private boolean isArgsMatch(DetailAST ast, List<String> args) {
        DetailAST dot = ast.findFirstToken(59);
        boolean result = dot == null || PreferMethodReferenceCheck.isCalledOnLiteral(dot) ? true : (dot.getChildCount(58) == 2 ? !args.contains(dot.findFirstToken(58).getText()) : this.detectForExpression && Collections.disjoint(args, PreferMethodReferenceCheck.getMethodInvocationIdents(ast)));
        return result;
    }

    private static boolean isCalledOnLiteral(DetailAST dot) {
        DetailAST firstExprPart = dot.getFirstChild();
        DetailAST firstExprPartLastToken = firstExprPart.getLastChild();
        return LITERAL_CALL_ARGS.contains(firstExprPart.getType()) || firstExprPartLastToken != null && firstExprPartLastToken.getType() == 69;
    }

    private static boolean matchesCtorArgs(DetailAST ast, List<String> args) {
        DetailAST elist = ast.findFirstToken(34);
        return elist != null && !PreferMethodReferenceCheck.isAnonClass(ast) && PreferMethodReferenceCheck.hasSameArgs(args, elist);
    }

    private static boolean matchesArrayInitializer(DetailAST ast, List<String> args) {
        DetailAST arrDecl = ast.findFirstToken(17);
        return arrDecl != null && args.size() == 1 && PreferMethodReferenceCheck.isArgUsedInArrayInit(arrDecl, args.get(0));
    }

    private static boolean shouldCheck(DetailAST ast) {
        return ast.getChildCount(28) == 1 && ast.getChildCount(45) == 1 && !TokenUtil.findFirstTokenByPredicate((DetailAST)ast, expr -> EXCLUDED_STATEMENTS_TOKEN_TYPES.contains(expr.getType())).isPresent();
    }

    private static boolean hasSameArgs(List<String> args, DetailAST ast) {
        boolean onlyIdents = true;
        ArrayList<String> idents = new ArrayList<String>();
        for (DetailAST node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 28 && node.findFirstToken(58) != null) {
                idents.add(node.findFirstToken(58).getText());
                continue;
            }
            if (node.getType() == 74) continue;
            onlyIdents = false;
            break;
        }
        return onlyIdents && idents.equals(args);
    }

    private static Set<String> getMethodInvocationIdents(DetailAST ast) {
        return Optional.ofNullable(ast.findFirstToken(59)).map(PreferMethodReferenceCheck::getExprIdents).orElse(Collections.emptySet());
    }

    private static boolean isCallOnArg(DetailAST ast, String arg) {
        DetailAST dot = ast.findFirstToken(59);
        return dot != null && dot.getChildCount(58) == 2 && arg.equals(dot.findFirstToken(58).getText());
    }

    private static boolean isAnonClass(DetailAST ast) {
        return ast.getLastChild().getType() == 6;
    }

    private static boolean isArgUsedInArrayInit(DetailAST declarator, String name) {
        boolean hasNoMultiDimensionalArrayWithExpressions = true;
        for (DetailAST nextSibling = declarator.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getType() != 17 || nextSibling.getFirstChild().getType() != 28) continue;
            hasNoMultiDimensionalArrayWithExpressions = false;
        }
        boolean isFirstArrayDeclaratorInit = declarator.getFirstChild().findFirstToken(58) != null && name.equals(declarator.getFirstChild().findFirstToken(58).getText());
        return isFirstArrayDeclaratorInit && hasNoMultiDimensionalArrayWithExpressions;
    }

    private static Set<String> getExprIdents(DetailAST ast) {
        HashSet<String> result = new HashSet<String>();
        for (DetailAST node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 58 && !PreferMethodReferenceCheck.isMethodIdent(node)) {
                result.add(node.getText());
                continue;
            }
            result.addAll(PreferMethodReferenceCheck.getExprIdents(node));
        }
        return result;
    }

    private static boolean isMethodIdent(DetailAST node) {
        int parentType;
        DetailAST nextSibling = node.getNextSibling();
        boolean result = nextSibling == null ? (parentType = node.getParent().getType()) == 59 || parentType == 180 : nextSibling.getType() == 34;
        return result;
    }
}

