/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Pattern;

public class ConstructorWithoutParamsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "constructor.without.params";
    private String classNameFormat = ".*Exception$";
    private String ignoredClassNameFormat = "UnsupportedOperationException";
    private Pattern regexp = CommonUtil.createPattern((String)this.classNameFormat);
    private Pattern ignoredRegexp = CommonUtil.createPattern((String)this.ignoredClassNameFormat);

    public void setClassNameFormat(String classNameFormat) {
        this.classNameFormat = classNameFormat;
        this.regexp = CommonUtil.createPattern((String)classNameFormat);
    }

    public void setIgnoredClassNameFormat(String ignoredClassNameFormat) {
        this.ignoredClassNameFormat = ignoredClassNameFormat;
        this.ignoredRegexp = CommonUtil.createPattern((String)this.ignoredClassNameFormat);
    }

    public int[] getDefaultTokens() {
        return new int[]{136};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST parameterListAST;
        int numberOfParameters;
        String className;
        DetailAST firstChild = ast.getFirstChild();
        if (firstChild != null && this.regexp.matcher(className = firstChild.getText()).find() && !this.ignoredRegexp.matcher(className).find() && ast.findFirstToken(17) == null && (numberOfParameters = (parameterListAST = ast.findFirstToken(34)).getChildCount()) == 0) {
            this.log(ast, MSG_KEY, new Object[]{className});
        }
    }
}

