/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.log4j.Logger;

class ZkEventThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(ZkEventThread.class);
    private BlockingQueue<ZkEvent> _events = new LinkedBlockingQueue<ZkEvent>();
    private static AtomicInteger _eventId = new AtomicInteger(0);

    ZkEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info((Object)"Starting ZkClient event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                LOG.debug((Object)("Delivering event #" + eventId + " " + zkEvent));
                try {
                    zkEvent.run();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error handling event " + zkEvent), e);
                }
                LOG.debug((Object)("Delivering event #" + eventId + " done"));
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Terminate ZkClient event thread.");
        }
    }

    public void send(ZkEvent event) {
        if (!this.isInterrupted()) {
            LOG.debug((Object)("New event: " + event));
            this._events.add(event);
        }
    }

    static abstract class ZkEvent {
        private String _description;

        public ZkEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkEvent[" + this._description + "]";
        }
    }
}

