/*
 * Decompiled with CFR 0.152.
 */
package com.github.sh0nk.matplotlib4j;

import com.github.sh0nk.matplotlib4j.Plot;
import com.github.sh0nk.matplotlib4j.PyCommand;
import com.github.sh0nk.matplotlib4j.PythonConfig;
import com.github.sh0nk.matplotlib4j.PythonExecutionException;
import com.github.sh0nk.matplotlib4j.builder.ArgsBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.Builder;
import com.github.sh0nk.matplotlib4j.builder.CLabelBuilder;
import com.github.sh0nk.matplotlib4j.builder.CLabelBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.ContourBuilder;
import com.github.sh0nk.matplotlib4j.builder.ContourBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.HistBuilder;
import com.github.sh0nk.matplotlib4j.builder.HistBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.LabelBuilder;
import com.github.sh0nk.matplotlib4j.builder.LabelBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.LegendBuilder;
import com.github.sh0nk.matplotlib4j.builder.LegendBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.PColorBuilder;
import com.github.sh0nk.matplotlib4j.builder.PColorBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.PlotBuilder;
import com.github.sh0nk.matplotlib4j.builder.PlotBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.SaveFigBuilder;
import com.github.sh0nk.matplotlib4j.builder.SaveFigBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.ScaleBuilder;
import com.github.sh0nk.matplotlib4j.builder.ScaleBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.SubplotBuilder;
import com.github.sh0nk.matplotlib4j.builder.SubplotBuilderImpl;
import com.github.sh0nk.matplotlib4j.builder.TextBuilder;
import com.github.sh0nk.matplotlib4j.builder.TextBuilderImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PlotImpl
implements Plot {
    @VisibleForTesting
    List<Builder> registeredBuilders = new LinkedList<Builder>();
    private List<Builder> showBuilders = new LinkedList<Builder>();
    private final boolean dryRun;
    private final PythonConfig pythonConfig;

    PlotImpl(PythonConfig pythonConfig, boolean dryRun) {
        this.pythonConfig = pythonConfig;
        this.dryRun = dryRun;
    }

    @VisibleForTesting
    PlotImpl(boolean dryRun) {
        this(PythonConfig.systemDefaultPythonConfig(), dryRun);
    }

    @Override
    public LegendBuilder legend() {
        LegendBuilderImpl builder = new LegendBuilderImpl();
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public void figure(String windowTitle) {
        this.registeredBuilders.add(new ArgsBuilderImpl("figure", windowTitle));
    }

    @Override
    public void title(String title) {
        this.registeredBuilders.add(new ArgsBuilderImpl("title", title));
    }

    @Override
    public LabelBuilder xlabel(String label) {
        LabelBuilderImpl builder = LabelBuilderImpl.xLabelBuilder(label);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public LabelBuilder ylabel(String label) {
        LabelBuilderImpl builder = LabelBuilderImpl.yLabelBuilder(label);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public ScaleBuilder xscale(ScaleBuilder.Scale scale) {
        ScaleBuilderImpl builder = ScaleBuilderImpl.xScaleBuilder(scale);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public ScaleBuilder yscale(ScaleBuilder.Scale scale) {
        ScaleBuilderImpl builder = ScaleBuilderImpl.yScaleBuilder(scale);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public void xlim(Number xmin, Number xmax) {
        this.registeredBuilders.add(new ArgsBuilderImpl("xlim", xmin, xmax));
    }

    @Override
    public void ylim(Number ymin, Number ymax) {
        this.registeredBuilders.add(new ArgsBuilderImpl("ylim", ymin, ymax));
    }

    @Override
    public TextBuilder text(double x, double y, String s) {
        TextBuilderImpl builder = new TextBuilderImpl(x, y, s);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public PlotBuilder plot() {
        PlotBuilderImpl builder = new PlotBuilderImpl();
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public ContourBuilder contour() {
        ContourBuilderImpl builder = new ContourBuilderImpl();
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public PColorBuilder pcolor() {
        PColorBuilderImpl builder = new PColorBuilderImpl();
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public HistBuilder hist() {
        HistBuilderImpl builder = new HistBuilderImpl();
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public CLabelBuilder clabel(ContourBuilder contour) {
        CLabelBuilderImpl builder = new CLabelBuilderImpl(contour);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public SaveFigBuilder savefig(String fname) {
        SaveFigBuilderImpl builder = new SaveFigBuilderImpl(fname);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public SubplotBuilder subplot(int nrows, int ncols, int index) {
        SubplotBuilderImpl builder = new SubplotBuilderImpl(nrows, ncols, index);
        this.registeredBuilders.add(builder);
        return builder;
    }

    @Override
    public void close() {
        this.registeredBuilders.add(new ArgsBuilderImpl("close"));
    }

    @Override
    public void close(String name) {
        this.registeredBuilders.add(new ArgsBuilderImpl("close", name));
    }

    @Override
    public void executeSilently() throws IOException, PythonExecutionException {
        LinkedList<String> scriptLines = new LinkedList<String>();
        scriptLines.add("import numpy as np");
        scriptLines.add("import matplotlib as mpl");
        scriptLines.add("mpl.use('Agg')");
        scriptLines.add("import matplotlib.pyplot as plt");
        this.registeredBuilders.forEach(b -> scriptLines.add(b.build()));
        this.showBuilders.forEach(b -> scriptLines.add(b.build()));
        PyCommand command = new PyCommand(this.pythonConfig);
        command.execute(Joiner.on((char)'\n').join(scriptLines));
    }

    @Override
    public void show() throws IOException, PythonExecutionException {
        LinkedList<String> scriptLines = new LinkedList<String>();
        scriptLines.add("import numpy as np");
        if (this.dryRun) {
            scriptLines.add("import matplotlib as mpl");
            scriptLines.add("mpl.use('Agg')");
        }
        scriptLines.add("import matplotlib.pyplot as plt");
        this.registeredBuilders.forEach(b -> scriptLines.add(b.build()));
        if (!this.dryRun) {
            scriptLines.add("plt.show()");
        }
        PyCommand command = new PyCommand(this.pythonConfig);
        command.execute(Joiner.on((char)'\n').join(scriptLines));
        this.registeredBuilders.clear();
    }
}

