/*
 * Decompiled with CFR 0.152.
 */
package com.github.sh0nk.matplotlib4j;

import com.github.sh0nk.matplotlib4j.PythonConfig;
import com.github.sh0nk.matplotlib4j.PythonExecutionException;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyCommand {
    private final PythonConfig pythonConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(PyCommand.class);
    private static final Pattern ERROR_PAT = Pattern.compile("^.+Error:");

    public PyCommand(PythonConfig pythonConfig) {
        this.pythonConfig = pythonConfig;
    }

    private List<String> buildCommandArgs(String scriptPath) {
        StringBuilder shell = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.pythonConfig.getPyenv())) {
            shell.append("pyenv shell ").append(this.pythonConfig.getPyenv()).append("; ");
            if (!Strings.isNullOrEmpty((String)this.pythonConfig.getVirtualenv())) {
                shell.append("export PYENV_VIRTUALENV_DISABLE_PROMPT=1; ");
                shell.append("pyenv activate ").append(this.pythonConfig.getVirtualenv()).append("; ");
            }
            shell.append("python ").append(scriptPath);
        }
        ArrayList com = !Strings.isNullOrEmpty((String)this.pythonConfig.getPythonBinPath()) ? Lists.newArrayList((Object[])new String[]{this.pythonConfig.getPythonBinPath(), scriptPath}) : (shell.length() != 0 ? Lists.newArrayList((Object[])new String[]{"bash", "-l", "-c", shell.toString()}) : Lists.newArrayList((Object[])new String[]{"python", scriptPath}));
        LOGGER.debug("Commands... : {}", (Object)com);
        return com;
    }

    private void command(List<String> commands) throws IOException, PythonExecutionException {
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process process = pb.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = br.readLine();
        while (line != null) {
            System.out.println(line);
            line = br.readLine();
        }
        br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        line = br.readLine();
        boolean hasError = false;
        while (line != null) {
            sb.append(line).append('\n');
            Matcher matcher = ERROR_PAT.matcher(line);
            if (matcher.find()) {
                hasError = true;
            }
            line = br.readLine();
        }
        String msg = sb.toString();
        if (hasError) {
            LOGGER.error(msg);
            throw new PythonExecutionException("Python execution error: " + msg);
        }
        LOGGER.warn(msg);
    }

    private void writeFile(String pythonScript, File script) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(script), StandardCharsets.UTF_8));
        bw.write(pythonScript);
        bw.close();
    }

    public void execute(String pythonScript) throws IOException, PythonExecutionException {
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        File script = new File(tmpDir, "exec.py");
        this.writeFile(pythonScript, script);
        String scriptPath = Paths.get(script.toURI()).toAbsolutePath().toString();
        this.command(this.buildCommandArgs(scriptPath));
        tmpDir.delete();
    }
}

