/*
 * Decompiled with CFR 0.152.
 */
package com.github.sh0nk.matplotlib4j.builder;

import com.github.sh0nk.matplotlib4j.builder.Builder;
import com.google.common.base.Joiner;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgsBuilderImpl
implements Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgsBuilderImpl.class);
    private final String key;
    List<Object> args = new LinkedList<Object>();

    public ArgsBuilderImpl(String key) {
        this.key = key;
    }

    public ArgsBuilderImpl(String key, String arg) {
        this.key = key;
        this.addStringToArgs(arg);
    }

    public ArgsBuilderImpl(String key, String arg1, String arg2) {
        this.key = key;
        this.addStringToArgs(arg1);
        this.addStringToArgs(arg2);
    }

    public ArgsBuilderImpl(String key, Number arg) {
        this.key = key;
        this.addStringToArgs(arg);
    }

    public ArgsBuilderImpl(String key, Number arg1, Number arg2) {
        this.key = key;
        this.addStringToArgs(arg1);
        this.addStringToArgs(arg2);
    }

    private ArgsBuilderImpl addStringToArgs(String v) {
        this.args.add("\"" + v + "\"");
        return this;
    }

    private ArgsBuilderImpl addStringToArgs(Number v) {
        this.args.add(v);
        return this;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append("plt.");
        sb.append(this.key);
        sb.append('(');
        Joiner.on((char)',').appendTo(sb, this.args);
        sb.append(')');
        String str = sb.toString();
        LOGGER.debug(".plot command: {}", (Object)str);
        return str;
    }

    @Override
    public String getMethodName() {
        return this.key;
    }
}

