/*
 * Decompiled with CFR 0.152.
 */
package com.github.sh0nk.matplotlib4j.builder;

import com.github.sh0nk.matplotlib4j.TypeConversion;
import com.github.sh0nk.matplotlib4j.builder.Builder;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeBuilder<T extends Builder>
implements Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeBuilder.class);
    private List<Object> args = new LinkedList<Object>();
    private Map<String, Object> kwargs = new HashMap<String, Object>();
    private String beforeMethodOutput = null;
    private String afterMethodOutput = null;
    private final T ownerBuilder;
    private String retName = "ret_" + UUID.randomUUID().toString().replace('-', '_');

    public CompositeBuilder(T ownerBuilder) {
        this.ownerBuilder = ownerBuilder;
    }

    private String wrapWithNdArray(String listAsStr) {
        return "np.array(" + listAsStr + ")";
    }

    public T addToArgs(List<? extends Number> numbers) {
        this.args.add(this.wrapWithNdArray(TypeConversion.INSTANCE.typeSafeList(numbers).toString()));
        return this.ownerBuilder;
    }

    public T add2DimListToArgs(List<? extends List<? extends Number>> numbers) {
        this.args.add(this.wrapWithNdArray(numbers.stream().map(TypeConversion.INSTANCE::typeSafeList).collect(Collectors.toList()).toString()));
        return this.ownerBuilder;
    }

    public T addToArgs(String v) {
        this.args.add("\"" + v + "\"");
        return this.ownerBuilder;
    }

    public T addToArgsWithoutQuoting(String v) {
        this.args.add(v);
        return this.ownerBuilder;
    }

    public T addToArgs(Number n) {
        this.args.add(n);
        return this.ownerBuilder;
    }

    public T addToKwargs(String k, String v) {
        this.kwargs.put(k, "\"" + v + "\"");
        return this.ownerBuilder;
    }

    public T addToKwargsWithoutQuoting(String k, String v) {
        this.kwargs.put(k, v);
        return this.ownerBuilder;
    }

    public T addToKwargs(String k, Number n) {
        this.kwargs.put(k, n);
        return this.ownerBuilder;
    }

    public T addToKwargs(String k, List<? extends Number> v) {
        this.kwargs.put(k, v);
        return this.ownerBuilder;
    }

    public T addToKwargs(String k, boolean v) {
        this.kwargs.put(k, v ? "True" : "False");
        return this.ownerBuilder;
    }

    public void beforeMethodOutput(String arg) {
        this.beforeMethodOutput = arg;
    }

    public void afterMethodOutput(String arg) {
        this.afterMethodOutput = arg;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        if (this.beforeMethodOutput != null) {
            sb.append(this.beforeMethodOutput).append('\n');
        }
        sb.append(this.retName).append(" = ");
        sb.append("plt.");
        sb.append(this.ownerBuilder.getMethodName());
        sb.append("(");
        Joiner.on((char)',').appendTo(sb, this.args);
        if (!this.kwargs.isEmpty()) {
            if (!this.args.isEmpty()) {
                sb.append(',');
            }
            Joiner.on((char)',').withKeyValueSeparator("=").appendTo(sb, this.kwargs);
        }
        sb.append(")");
        if (this.afterMethodOutput != null) {
            sb.append('\n').append(this.afterMethodOutput);
        }
        String str = sb.toString();
        LOGGER.debug(".plot command: {}", (Object)str);
        return str;
    }

    @Override
    public String getMethodName() {
        throw new UnsupportedOperationException("CompositeBuilder doesn't have any real method.");
    }

    public String getRetName() {
        return this.retName;
    }
}

