/*
 * Decompiled with CFR 0.152.
 */
package com.github.sh0nk.matplotlib4j.builder;

import com.github.sh0nk.matplotlib4j.builder.CompositeBuilder;
import com.github.sh0nk.matplotlib4j.builder.HistBuilder;
import com.github.sh0nk.matplotlib4j.kwargs.PatchBuilder;
import com.github.sh0nk.matplotlib4j.kwargs.PatchBuilderImpl;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;

public class HistBuilderImpl
implements HistBuilder {
    private CompositeBuilder<HistBuilder> innerBuilder = new CompositeBuilder<HistBuilderImpl>(this);
    private PatchBuilder<HistBuilder> patchBuilder = new PatchBuilderImpl<HistBuilder>(this.innerBuilder);
    private List<List<? extends Number>> xList = new LinkedList<List<? extends Number>>();

    @Override
    public HistBuilder add(List<? extends Number> nums) {
        this.xList.add(nums);
        return this;
    }

    @Override
    public HistBuilder bins(int arg) {
        return this.innerBuilder.addToKwargs("bins", arg);
    }

    @Override
    public HistBuilder bins(List<? extends Number> nums) {
        return this.innerBuilder.addToKwargs("bins", nums);
    }

    @Override
    public HistBuilder range(double lower, double upper) {
        return this.innerBuilder.addToKwargsWithoutQuoting("range", String.format("(%f, %f)", lower, upper));
    }

    @Override
    public HistBuilder density(boolean arg) {
        return this.innerBuilder.addToKwargs("density", arg);
    }

    @Override
    public HistBuilder weights(List<? extends Number> nums) {
        return this.innerBuilder.addToKwargs("weights", nums);
    }

    @Override
    public HistBuilder cumulative(boolean arg) {
        return this.innerBuilder.addToKwargs("cumulative", arg);
    }

    @Override
    public HistBuilder bottom(double arg) {
        return this.innerBuilder.addToKwargs("bottom", arg);
    }

    @Override
    public HistBuilder bottom(List<? extends Number> nums) {
        return this.innerBuilder.addToKwargs("bottom", nums);
    }

    @Override
    public HistBuilder histtype(HistBuilder.HistType histType) {
        return this.innerBuilder.addToKwargs("histtype", histType.toString());
    }

    @Override
    public HistBuilder align(HistBuilder.Align align) {
        return this.innerBuilder.addToKwargs("align", align.name());
    }

    @Override
    public HistBuilder orientation(HistBuilder.Orientation orientation) {
        return this.innerBuilder.addToKwargs("orientation", orientation.name());
    }

    @Override
    public HistBuilder rwidth(double arg) {
        return this.innerBuilder.addToKwargs("rwidth", arg);
    }

    @Override
    public HistBuilder log(boolean arg) {
        return this.innerBuilder.addToKwargs("log", arg);
    }

    @Override
    public HistBuilder color(String ... args) {
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0, (Object)".color() needs to have at least one argument.");
        return this.innerBuilder.addToKwargsWithoutQuoting("color", "[\"" + Joiner.on((String)"\", \"").join((Object[])args) + "\"]");
    }

    @Override
    public HistBuilder stacked(boolean arg) {
        return this.innerBuilder.addToKwargs("stacked", arg);
    }

    @Override
    public HistBuilder linestyle(String arg) {
        return this.patchBuilder.linestyle(arg);
    }

    @Override
    public HistBuilder ls(String arg) {
        return this.patchBuilder.ls(arg);
    }

    @Override
    public HistBuilder linewidth(double arg) {
        return this.patchBuilder.linewidth(arg);
    }

    @Override
    public HistBuilder lw(double arg) {
        return this.patchBuilder.lw(arg);
    }

    @Override
    public HistBuilder label(String arg) {
        return this.patchBuilder.label(arg);
    }

    @Override
    public String build() {
        Preconditions.checkArgument((this.xList.size() > 0 ? 1 : 0) != 0, (Object)".add() is needed to be called at least once.");
        this.innerBuilder.addToArgsWithoutQuoting(this.xList.toString());
        return this.innerBuilder.build();
    }

    @Override
    public String getMethodName() {
        return "hist";
    }
}

