/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    private static String serverIp;

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            ip = IpUtil.getServerIp();
        }
        return ip;
    }

    public static String getServerIp() {
        return serverIp;
    }

    public static Map<String, String> getLocalIPV4() {
        HashMap<String, String> map = new HashMap<String, String>();
        InetAddress ip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ip = ips.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    map.put(ni.getName(), ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> getLocalIPV6() {
        HashMap<String, String> map = new HashMap<String, String>();
        InetAddress ip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ip = ips.nextElement();
                    if (!(ip instanceof Inet6Address)) continue;
                    map.put(ni.getName(), ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    static {
        InetAddress ia = null;
        try {
            ia = ia.getLocalHost();
            serverIp = ia.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

