/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

public class PrettyMemoryUtil {
    private static final int UNIT = 1024;

    public static String prettyByteSize(long byteSize) {
        double size = 1.0 * (double)byteSize;
        if ((int)Math.floor(size / 1024.0) <= 0) {
            String type = "B";
            return PrettyMemoryUtil.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            String type = "KB";
            return PrettyMemoryUtil.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            String type = "MB";
            return PrettyMemoryUtil.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            String type = "GB";
            return PrettyMemoryUtil.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            String type = "TB";
            return PrettyMemoryUtil.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            String type = "PB";
            return PrettyMemoryUtil.format(size, type);
        }
        return ">PB";
    }

    private static String format(double size, String type) {
        int precision = 0;
        if (size * 1000.0 % 10.0 > 0.0) {
            precision = 3;
        } else if (size * 100.0 % 10.0 > 0.0) {
            precision = 2;
        } else if (size * 10.0 % 10.0 > 0.0) {
            precision = 1;
        }
        String formatStr = "%." + precision + "f";
        if ("KB".equals(type)) {
            return String.format(formatStr, size) + "KB";
        }
        if ("MB".equals(type)) {
            return String.format(formatStr, size) + "MB";
        }
        if ("GB".equals(type)) {
            return String.format(formatStr, size) + "GB";
        }
        if ("TB".equals(type)) {
            return String.format(formatStr, size) + "TB";
        }
        if ("PB".equals(type)) {
            return String.format(formatStr, size) + "PB";
        }
        return String.format(formatStr, size) + "B";
    }
}

