/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.common.util.FileUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import org.beetl.core.Template;

public class RpcHtmlBuilder {
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "rpc-index.html";
    private static String SEARCH_JS = "search.js";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        RpcHtmlBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setShowJavaType(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<RpcApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        Template indexCssTemplate = BeetlTemplateUtil.getByName("css/AllInOne.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
        RpcDocBuilderTemplate.copyJarFile("css/font.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "font.css");
        RpcDocBuilderTemplate.copyJarFile("js/jquery.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "jquery.min.js");
        builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.html", INDEX_HTML);
        builderTemplate.buildSearchJs(apiDocList, config, "dubbo/DubboSearch.btl", SEARCH_JS);
    }
}

