/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.google.gson.Gson;
import com.power.common.util.CollectionUtil;
import com.power.common.util.OkHttp3Util;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.constants.TornaConstants;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.model.torna.Apis;
import com.power.doc.model.torna.DubboInfo;
import com.power.doc.model.torna.TornaApi;
import com.power.doc.model.torna.TornaDic;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.TornaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RpcTornaBuilder {
    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        RpcTornaBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setParamsDataToTree(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<RpcApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        RpcTornaBuilder.buildTorna(apiDocList, config, javaProjectBuilder);
    }

    public static void buildTorna(List<RpcApiDoc> apiDocs, ApiConfig apiConfig, JavaProjectBuilder builder) {
        Map<String, String> dicRequestJson;
        TornaApi tornaApi = new TornaApi();
        tornaApi.setAuthor(StringUtil.isEmpty((String)apiConfig.getAuthor()) ? System.getProperty("user.name") : apiConfig.getAuthor());
        tornaApi.setIsReplace(apiConfig.getReplace() == null || apiConfig.getReplace() != false ? 1 : 0);
        ArrayList<Apis> apisList = new ArrayList<Apis>();
        for (RpcApiDoc a : apiDocs) {
            Apis api = new Apis();
            api.setName(StringUtils.isBlank((CharSequence)a.getDesc()) ? a.getName() : a.getDesc());
            TornaUtil.setDebugEnv(apiConfig, tornaApi);
            api.setItems(TornaUtil.buildDubboApis(a.getList()));
            api.setIsFolder("1");
            api.setAuthor(a.getAuthor());
            api.setDubboInfo(new DubboInfo().builder().setAuthor(a.getAuthor()).setProtocol(a.getProtocol()).setVersion(a.getVersion()).setDependency(TornaUtil.buildDependencies(apiConfig.getRpcApiDependencies())).setInterfaceName(a.getName()));
            api.setOrderIndex(a.getOrder());
            apisList.add(api);
        }
        tornaApi.setCommonErrorCodes(TornaUtil.buildErrorCode(apiConfig));
        tornaApi.setApis(apisList);
        Map<String, String> requestJson = TornaConstants.buildParams("doc.push", new Gson().toJson((Object)tornaApi), apiConfig);
        HashMap<String, List<TornaDic>> dicMap = new HashMap<String, List<TornaDic>>(2);
        List<TornaDic> docDicts = TornaUtil.buildTornaDic(DocUtil.buildDictionary(apiConfig, builder));
        if (CollectionUtil.isNotEmpty(docDicts)) {
            dicMap.put("enums", docDicts);
            dicRequestJson = TornaConstants.buildParams("enum.batch.push", new Gson().toJson(dicMap), apiConfig);
            String dicResponseMsg = OkHttp3Util.syncPostJson((String)apiConfig.getOpenUrl(), (String)new Gson().toJson(dicRequestJson));
            TornaUtil.printDebugInfo(apiConfig, dicResponseMsg, dicRequestJson, "enum.batch.push");
        }
        dicRequestJson = TornaConstants.buildParams("enum.batch.push", new Gson().toJson(dicMap), apiConfig);
        String responseMsg = OkHttp3Util.syncPostJson((String)apiConfig.getOpenUrl(), (String)new Gson().toJson(requestJson));
        TornaUtil.printDebugInfo(apiConfig, responseMsg, requestJson, "doc.push");
    }
}

