/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.openapi;

import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.openapi.AbstractOpenApiBuilder;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiGroup;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.openapi.OpenApiTag;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SwaggerBuilder
extends AbstractOpenApiBuilder {
    private static final SwaggerBuilder INSTANCE = new SwaggerBuilder();

    public static void buildOpenApi(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        SwaggerBuilder.buildOpenApi(config, javaProjectBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        List<ApiDoc> apiDocList = INSTANCE.getOpenApiDocs(config, projectBuilder);
        INSTANCE.openApiCreate(config, apiDocList);
    }

    @Override
    public void openApiCreate(ApiConfig config, List<ApiDoc> apiDocList) {
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("swagger", "2.0");
        json.put("info", SwaggerBuilder.buildInfo(config));
        json.put("host", config.getServerUrl() == null ? "127.0.0.1" : config.getServerUrl());
        json.put("basePath", StringUtils.isNotBlank((CharSequence)config.getPathPrefix()) ? config.getPathPrefix() : "/");
        HashSet<OpenApiTag> tags = new HashSet<OpenApiTag>();
        json.put("tags", tags);
        json.put("paths", this.buildPaths(config, apiDocList, tags));
        json.put("definitions", this.buildComponentsSchema(apiDocList));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    @Deprecated
    private static List<Map<String, String>> buildTags(ApiConfig config) {
        ArrayList<Map<String, String>> tagList = new ArrayList<Map<String, String>>();
        List<ApiGroup> groups = config.getGroups();
        for (ApiGroup group : groups) {
            HashMap<String, String> tagMap = new HashMap<String, String>(4);
            tagMap.put("name", group.getName());
            tagMap.put("description", group.getApis());
            tagList.add(tagMap);
        }
        return tagList;
    }

    @Override
    public Map<String, Object> buildPathUrlsRequest(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        if (StringUtil.isNotEmpty((String)apiMethodDoc.getGroup())) {
            request.put("tags", new String[]{apiDoc.getDesc()});
        } else {
            request.put("tags", new String[]{apiDoc.getDesc()});
        }
        List<Map<String, Object>> parameters = this.buildParameters(apiMethodDoc);
        if (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("in", "body");
            parameter.putAll(SwaggerBuilder.buildContentBody(apiConfig, apiMethodDoc, false, "#/definitions/"));
            parameters.add(parameter);
        }
        request.put("parameters", parameters);
        request.put("responses", this.buildResponses(apiConfig, apiMethodDoc));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        request.put("operationId", String.join((CharSequence)"", OpenApiSchemaUtil.getPatternResult("[A-Za-z0-9{}]*", apiMethodDoc.getPath())));
        return request;
    }

    @Override
    public Map<String, Object> buildResponsesBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        if (CollectionUtil.isNotEmpty(apiMethodDoc.getResponseParams())) {
            responseBody.putAll(SwaggerBuilder.buildContentBody(apiConfig, apiMethodDoc, true, "#/definitions/"));
        }
        return responseBody;
    }

    @Override
    List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        List<ApiParam> children;
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = this.getStringParams(apiParam, false);
            parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType()));
            parameters.put("in", "path");
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
            if (apiParam.isHasItems()) {
                parameters = this.getStringParams(apiParam, false);
                parameters.put("type", "array");
                parameters.put("items", this.getStringParams(apiParam, true));
                parametersList.add(parameters);
                continue;
            }
            parameters = this.getStringParams(apiParam, false);
            parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType()));
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(header.getType()));
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("example", header.getValue());
                parameters.put("schema", SwaggerBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    @Override
    Map<String, Object> getStringParams(ApiParam apiParam, boolean hasItems) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        if ("file".equalsIgnoreCase(apiParam.getType())) {
            parameters.put("in", "formData");
        } else {
            parameters.put("in", "query");
        }
        if (!hasItems) {
            parameters.put("name", apiParam.getField());
            parameters.put("description", apiParam.getDesc());
            parameters.put("required", apiParam.isRequired());
            parameters.put("example", StringUtil.removeQuotes((String)apiParam.getValue()));
        }
        parameters.put("type", apiParam.getType());
        return parameters;
    }

    @Override
    public Map<String, Object> buildComponentsSchema(List<ApiDoc> apiDocs) {
        HashMap<String, Object> component = new HashMap<String, Object>();
        component.put("string", STRING_COMPONENT);
        apiDocs.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String requestSchema = OpenApiSchemaUtil.getClassNameFromParams(method.getRequestParams());
                List<ApiParam> requestParams = method.getRequestParams();
                Map<String, Object> prop = SwaggerBuilder.buildProperties(requestParams, component, "#/definitions/");
                component.put(requestSchema, prop);
                List<ApiParam> responseParams = method.getResponseParams();
                String schemaName = OpenApiSchemaUtil.getClassNameFromParams(method.getResponseParams());
                component.put(schemaName, SwaggerBuilder.buildProperties(responseParams, component, "#/definitions/"));
            });
        });
        component.remove("NO_BODY_PARAM");
        return component;
    }
}

