/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.common.util.FileUtil;
import com.power.doc.builder.BaseDocBuilderTemplate;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.utils.BeetlTemplateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import org.beetl.core.Template;

public class RpcHtmlBuilder {
    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        RpcHtmlBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        List<RpcApiDoc> apiDocList = builderTemplate.getRpcApiDoc(config, javaProjectBuilder);
        Template indexCssTemplate = BeetlTemplateUtil.getByName("css/AllInOne.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
        BaseDocBuilderTemplate.copyJarFile("css/font.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "font.css");
        BaseDocBuilderTemplate.copyJarFile("js/jquery.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "jquery.min.js");
        String INDEX_HTML = "rpc-index.html";
        builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.html", INDEX_HTML);
        String SEARCH_JS = "search.js";
        builderTemplate.buildSearchJs(apiDocList, config, javaProjectBuilder, "dubbo/DubboSearch.btl", SEARCH_JS);
    }
}

