/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SolonRequestAnnotationsEnum;
import com.power.doc.handler.SolonRequestHeaderHandler;
import com.power.doc.handler.SolonRequestMappingHandler;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.annotation.EntryAnnotation;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.annotation.HeaderAnnotation;
import com.power.doc.model.annotation.MappingAnnotation;
import com.power.doc.model.annotation.PathVariableAnnotation;
import com.power.doc.model.annotation.RequestBodyAnnotation;
import com.power.doc.model.annotation.RequestParamAnnotation;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.template.IRestDocTemplate;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SolonDocBuildTemplate
implements IDocBuildTemplate<ApiDoc>,
IRestDocTemplate {
    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        List<ApiReqParam> configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        List<ApiDoc> apiDocList = this.processApiData(projectBuilder, frameworkAnnotations, configApiReqParams, new SolonRequestMappingHandler(), new SolonRequestHeaderHandler());
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        }
        return apiDocList;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName, ignoreParams);
    }

    @Override
    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        for (JavaAnnotation annotation : cls.getAnnotations()) {
            String name = annotation.getType().getValue();
            if (!"Remoting".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listMvcRequestAnnotations() {
        return SolonRequestAnnotationsEnum.listMvcRequestAnnotations();
    }

    @Override
    public void requestMappingPostProcess(JavaClass javaClass, JavaMethod method, RequestMapping requestMapping) {
        if (Objects.isNull(requestMapping)) {
            return;
        }
        if (javaClass.isAnnotation() || javaClass.isEnum()) {
            return;
        }
        boolean isRemote = false;
        for (JavaAnnotation annotation : javaClass.getAnnotations()) {
            String name = annotation.getType().getValue();
            if (!"Remoting".equals(name)) continue;
            isRemote = true;
        }
        if (isRemote) {
            requestMapping.setMethodType(Methods.POST.getValue());
            String shortUrl = requestMapping.getShortUrl();
            String mediaType = requestMapping.getMediaType();
            if (shortUrl == null) {
                requestMapping.setShortUrl(method.getName());
            }
            if (mediaType == null) {
                requestMapping.setMediaType("text/json");
            }
        }
    }

    @Override
    public boolean ignoreMvcParamWithAnnotation(String annotation) {
        return JavaClassValidateUtil.ignoreSolonMvcParamWithAnnotation(annotation);
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        FrameworkAnnotations annotations = FrameworkAnnotations.builder();
        HeaderAnnotation headerAnnotation = HeaderAnnotation.builder().setAnnotationName("Header").setValueProp("value").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setHeaderAnnotation(headerAnnotation);
        HashMap<String, EntryAnnotation> entryAnnotations = new HashMap<String, EntryAnnotation>();
        EntryAnnotation controllerAnnotation = EntryAnnotation.builder().setAnnotationName("Controller").setAnnotationFullyName("Controller");
        entryAnnotations.put(controllerAnnotation.getAnnotationName(), controllerAnnotation);
        EntryAnnotation remoteController = EntryAnnotation.builder().setAnnotationName("Remoting");
        entryAnnotations.put(remoteController.getAnnotationName(), remoteController);
        EntryAnnotation componentController = EntryAnnotation.builder().setAnnotationName("Component");
        entryAnnotations.put(componentController.getAnnotationName(), componentController);
        annotations.setEntryAnnotations(entryAnnotations);
        RequestBodyAnnotation bodyAnnotation = RequestBodyAnnotation.builder().setAnnotationName("Body").setAnnotationFullyName("org.noear.solon.annotation.Body");
        annotations.setRequestBodyAnnotation(bodyAnnotation);
        RequestParamAnnotation requestAnnotation = RequestParamAnnotation.builder().setAnnotationName("Param").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setRequestParamAnnotation(requestAnnotation);
        PathVariableAnnotation pathVariableAnnotation = PathVariableAnnotation.builder().setAnnotationName("PathVar").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setPathVariableAnnotation(pathVariableAnnotation);
        HashMap<String, MappingAnnotation> mappingAnnotations = new HashMap<String, MappingAnnotation>();
        MappingAnnotation requestMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Mapping").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setScope("class", "method").setPathProps("value", "name", "path");
        mappingAnnotations.put(requestMappingAnnotation.getAnnotationName(), requestMappingAnnotation);
        MappingAnnotation postMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Post").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.POST.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(postMappingAnnotation.getAnnotationName(), postMappingAnnotation);
        MappingAnnotation getMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Get").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.GET.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(getMappingAnnotation.getAnnotationName(), getMappingAnnotation);
        MappingAnnotation putMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Put").setProducesProp("produces").setParamsProp("params").setMethodProp("method").setMethodType(Methods.PUT.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(putMappingAnnotation.getAnnotationName(), putMappingAnnotation);
        MappingAnnotation patchMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Patch").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.PATCH.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(patchMappingAnnotation.getAnnotationName(), patchMappingAnnotation);
        MappingAnnotation deleteMappingAnnotation = MappingAnnotation.builder().setAnnotationName("Delete").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.DELETE.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(deleteMappingAnnotation.getAnnotationName(), deleteMappingAnnotation);
        MappingAnnotation feignClientAnnotation = MappingAnnotation.builder().setAnnotationName("FeignClient").setAnnotationFullyName("org.springframework.cloud.netflix.feign.FeignClient");
        mappingAnnotations.put(feignClientAnnotation.getAnnotationName(), feignClientAnnotation);
        annotations.setMappingAnnotations(mappingAnnotations);
        return annotations;
    }
}

