/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.mifmif.common.regex.Generex;
import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.EnumUtil;
import com.power.common.util.IDCardUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.doc.extension.dict.DictionaryValuesResolver;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiDocDict;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiErrorCodeDictionary;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaField;
import com.power.doc.model.FormData;
import com.power.doc.model.SystemPlaceholders;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocPathUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.expression.Add;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.model.expression.FieldRef;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.datafaker.Faker;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class DocUtil {
    private static final Faker faker = new Faker(new Locale("en-US"));
    private static final Faker enFaker = new Faker(new Locale("en-US"));
    private static final Map<String, String> fieldValue = new LinkedHashMap<String, String>();
    private static final Map<String, Pattern> patternCache;
    private static final Map<String, Set<String>> filterMethodCache;

    public static String jsonValueByType(String typeName) {
        String type = typeName.contains(".") ? typeName.substring(typeName.lastIndexOf(".") + 1) : typeName;
        String randomMock = System.getProperty("randomMock");
        Boolean randomMockFlag = Boolean.parseBoolean(randomMock);
        String value = "";
        value = randomMockFlag != false ? RandomUtil.randomValueByType((String)type) : RandomUtil.generateDefaultValueByType((String)type);
        if (DocUtil.javaPrimaryType(type)) {
            return value;
        }
        if ("Void".equals(type)) {
            return "null";
        }
        return "\"" + value + "\"";
    }

    public static String getValByTypeAndFieldName(String typeName, String filedName) {
        String randomMock = System.getProperty("randomMock");
        Boolean randomMockFlag = Boolean.parseBoolean(randomMock);
        boolean isArray = true;
        String type = typeName.contains("java.lang") ? typeName.substring(typeName.lastIndexOf(".") + 1) : typeName;
        String key = filedName.toLowerCase() + "-" + type.toLowerCase();
        StringBuilder value = null;
        if (!type.contains("[")) {
            isArray = false;
        }
        if (!randomMockFlag.booleanValue()) {
            return DocUtil.jsonValueByType(typeName);
        }
        for (Map.Entry<String, String> entry : fieldValue.entrySet()) {
            if (!key.contains(entry.getKey())) continue;
            value = new StringBuilder(entry.getValue());
            if (!isArray) break;
            for (int i = 0; i < 2; ++i) {
                value.append(",").append(entry.getValue());
            }
        }
        if (Objects.isNull(value)) {
            return DocUtil.jsonValueByType(typeName);
        }
        if (DocUtil.javaPrimaryType(type)) {
            return value.toString();
        }
        return DocUtil.handleJsonStr(value.toString());
    }

    public static String getValByTypeAndFieldName(String type0, String filedName, boolean removeDoubleQuotation) {
        if (removeDoubleQuotation) {
            return DocUtil.getValByTypeAndFieldName(type0, filedName).replace("\"", "");
        }
        return DocUtil.getValByTypeAndFieldName(type0, filedName);
    }

    public static boolean isMatch(String packageFilters, String controllerName) {
        String[] patterns;
        if (StringUtil.isEmpty((String)packageFilters)) {
            return false;
        }
        for (String str : patterns = packageFilters.split(",")) {
            Pattern pattern;
            if (!(str.contains("*") ? (pattern = Pattern.compile(str)).matcher(controllerName).matches() : controllerName.startsWith(str))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(String packageFilters, JavaClass controllerClass) {
        String[] filters;
        if (StringUtil.isEmpty((String)packageFilters)) {
            return false;
        }
        String controllerName = controllerClass.getCanonicalName();
        for (String filter : filters = packageFilters.split(",")) {
            if (filter.contains("*")) {
                Pattern pattern = DocUtil.getPattern(filter);
                boolean matchControllerName = pattern.matcher(controllerName).matches();
                if (matchControllerName) {
                    DocUtil.cacheFilterMethods(controllerName, Collections.singleton("*"));
                    return true;
                }
                List controllerMethods = controllerClass.getMethods().stream().map(JavaMember::getName).collect(Collectors.toList());
                Set<String> methodsMatch = controllerMethods.stream().filter(method -> pattern.matcher(controllerName + "." + method).matches()).collect(Collectors.toSet());
                if (methodsMatch.isEmpty()) continue;
                DocUtil.cacheFilterMethods(controllerName, methodsMatch);
                return true;
            }
            if (controllerName.equals(filter) || controllerName.contains(filter)) {
                DocUtil.cacheFilterMethods(controllerName, Collections.singleton("*"));
                return true;
            }
            if (!filter.contains(controllerName)) continue;
            String method2 = filter.replace(controllerName, "").replace(".", "");
            DocUtil.cacheFilterMethods(controllerName, Collections.singleton(method2));
            return true;
        }
        return false;
    }

    private static Pattern getPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    private static void cacheFilterMethods(String controller, Set<String> methods) {
        filterMethodCache.put(controller, methods);
    }

    private static Set<String> getFilterMethodsCache(String controller) {
        return filterMethodCache.getOrDefault(controller, Collections.singleton("*"));
    }

    public static Set<String> findFilterMethods(String controllerName) {
        return DocUtil.getFilterMethodsCache(controllerName);
    }

    public static String formatAndRemove(String str, Map<String, String> values) {
        if (SystemPlaceholders.hasSystemProperties(str)) {
            str = DocUtil.delPropertiesUrl(str, new HashSet<String>());
        }
        if (!str.contains(":")) {
            return str;
        }
        if (str.contains(":")) {
            List<String> pathList = DocUtil.splitPathBySlash(str);
            ArrayList<String> finalPaths = new ArrayList<String>(pathList.size());
            for (String pathParam : pathList) {
                if (pathParam.startsWith("http:") || pathParam.startsWith("https:")) {
                    finalPaths.add(pathParam + "/");
                    continue;
                }
                if (pathParam.startsWith("${")) {
                    finalPaths.add(pathParam);
                    continue;
                }
                if (pathParam.contains(":") && pathParam.startsWith("{")) {
                    int length = pathParam.length();
                    String reg = pathParam.substring(pathParam.indexOf(":") + 1, length - 1);
                    Generex generex = new Generex(reg);
                    String randomStr = generex.random();
                    String key = pathParam.substring(1, pathParam.indexOf(":"));
                    if (!values.containsKey(key)) {
                        values.put(key, randomStr);
                    }
                    String path = pathParam.substring(0, pathParam.indexOf(":")) + "}";
                    finalPaths.add(path);
                    continue;
                }
                finalPaths.add(pathParam);
            }
            str = StringUtils.join(finalPaths, (char)'/');
        }
        StringBuilder builder = new StringBuilder(str);
        Set<Map.Entry<String, String>> entries = values.entrySet();
        Iterator<Map.Entry<String, String>> iteratorMap = entries.iterator();
        while (iteratorMap.hasNext()) {
            int start;
            Map.Entry<String, String> next = iteratorMap.next();
            String pattern = "{" + next.getKey() + "}";
            String value = next.getValue();
            while ((start = builder.indexOf(pattern)) != -1) {
                builder.replace(start, start + pattern.length(), value);
            }
            iteratorMap.remove();
            values.remove(next.getKey());
        }
        return builder.toString();
    }

    public static String formatPathUrl(String str) {
        if (SystemPlaceholders.hasSystemProperties(str)) {
            str = DocUtil.delPropertiesUrl(str, new HashSet<String>());
        }
        if (!str.contains(":")) {
            return str;
        }
        StringBuilder urlBuilder = new StringBuilder();
        String[] urls = str.split(";");
        int index = 0;
        for (String url : urls) {
            String[] strArr = url.split("/");
            for (int i = 0; i < strArr.length; ++i) {
                String pathParam = strArr[i];
                if (pathParam.startsWith("http:") || pathParam.startsWith("https:") || pathParam.startsWith("{{") || !pathParam.startsWith("{") || !pathParam.contains(":")) continue;
                strArr[i] = pathParam.substring(0, pathParam.indexOf(":")) + "}";
            }
            if (index < urls.length - 1) {
                urlBuilder.append(StringUtils.join(Arrays.asList(strArr), (char)'/')).append(";");
            } else {
                urlBuilder.append(StringUtils.join(Arrays.asList(strArr), (char)'/'));
            }
            ++index;
        }
        return urlBuilder.toString();
    }

    public static String handleHttpMethod(String method) {
        switch (method) {
            case "RequestMethod.GET": 
            case "MethodType.GET": {
                return "GET";
            }
            case "RequestMethod.POST": 
            case "MethodType.POST": {
                return "POST";
            }
            case "RequestMethod.PUT": 
            case "MethodType.PUT": {
                return "PUT";
            }
            case "RequestMethod.DELETE": 
            case "MethodType.DELETE": {
                return "DELETE";
            }
            case "RequestMethod.PATCH": 
            case "MethodType.PATCH": {
                return "PATCH";
            }
        }
        return "GET";
    }

    public static String handleMappingValue(JavaAnnotation annotation) {
        String url = DocUtil.getRequestMappingUrl(annotation);
        if (StringUtil.isEmpty((String)url)) {
            return "/";
        }
        return StringUtil.trimBlank((String)url);
    }

    public static List<String> split(String url) {
        char[] chars = url.toCharArray();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        for (char s : chars) {
            if ('[' == s || ']' == s) continue;
            if ('{' == s) {
                stack.push(Character.valueOf(s));
            }
            if ('}' == s) {
                if (stack.isEmpty()) {
                    throw new RuntimeException("Invalid mapping pattern detected: " + url);
                }
                stack.pop();
            }
            if (',' == s && stack.isEmpty()) {
                result.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(s);
        }
        result.add(sb.toString());
        return result;
    }

    public static Map<String, String> getCommentsByTag(JavaMethod javaMethod, String tagName, String className) {
        List paramTags = javaMethod.getTagsByName(tagName);
        HashMap<String, String> paramTagMap = new HashMap<String, String>();
        for (DocletTag docletTag : paramTags) {
            String value = docletTag.getValue();
            if (StringUtil.isEmpty((String)value) && StringUtil.isNotEmpty((String)className)) {
                throw new RuntimeException("ERROR: #" + javaMethod.getName() + "() - bad @" + tagName + " javadoc from " + javaMethod.getDeclaringClass().getCanonicalName() + ", This is an invalid comment.");
            }
            if ("param".equals(tagName)) {
                String pName = value;
                String pValue = "No comments found.";
                int idx = value.indexOf(" ");
                if (idx > -1) {
                    pName = value.substring(0, idx);
                    pValue = value.substring(idx + 1);
                }
                if ("|".equals(StringUtil.trim((String)pValue)) && StringUtil.isNotEmpty((String)className)) {
                    throw new RuntimeException("ERROR: An invalid comment was written [@" + tagName + " |],Please @see " + javaMethod.getDeclaringClass().getCanonicalName() + "." + javaMethod.getName() + "()");
                }
                paramTagMap.put(pName, pValue);
                continue;
            }
            paramTagMap.put(value, "");
        }
        return paramTagMap;
    }

    public static String getNormalTagComments(JavaMethod javaMethod, String tagName, String className) {
        Map<String, String> map = DocUtil.getCommentsByTag(javaMethod, tagName, className);
        return DocUtil.getFirstKeyAndValue(map);
    }

    public static Map<String, String> getFieldTagsValue(JavaField field, DocJavaField docJavaField) {
        List<DocletTag> paramTags = field.getTags();
        if (CollectionUtil.isEmpty((Collection)paramTags) && Objects.nonNull(docJavaField)) {
            paramTags = docJavaField.getDocletTags();
        }
        return paramTags.stream().collect(Collectors.toMap(DocletTag::getName, DocletTag::getValue, (key1, key2) -> key1 + "," + key2));
    }

    public static String getFirstKeyAndValue(Map<String, String> map) {
        Map.Entry<String, String> entry;
        String value = null;
        if (map != null && map.size() > 0 && (entry = map.entrySet().iterator().next()) != null) {
            value = "No comments found.".equals(entry.getValue()) ? entry.getKey() : entry.getKey() + entry.getValue();
        }
        return value;
    }

    public static String generateId(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        String valueId = DigestUtils.md5Hex((String)value);
        int length = valueId.length();
        if (valueId.length() < 32) {
            return valueId;
        }
        return valueId.substring(length - 32, length);
    }

    public static String replaceNewLineToHtmlBr(String content) {
        if (StringUtil.isNotEmpty((String)content)) {
            return content.replaceAll("(\r\n|\r|\n|\n\r)", "<br>");
        }
        return "";
    }

    public static String handleJsonStr(String content) {
        return "\"" + content + "\"";
    }

    public static Map<String, String> formDataToMap(List<FormData> formDataList) {
        IdentityHashMap<String, String> formDataMap = new IdentityHashMap<String, String>();
        for (FormData formData : formDataList) {
            if ("file".equals(formData.getType())) continue;
            if (formData.getKey().contains("[]")) {
                String key = formData.getKey().substring(0, formData.getKey().indexOf("["));
                formDataMap.put(key, formData.getValue() + "&" + key + "=" + formData.getValue());
                continue;
            }
            formDataMap.put(formData.getKey(), formData.getValue());
        }
        return formDataMap;
    }

    public static boolean javaPrimaryType(String type) {
        switch (type) {
            case "Integer": 
            case "int": 
            case "Long": 
            case "long": 
            case "Double": 
            case "double": 
            case "Float": 
            case "Number": 
            case "float": 
            case "Boolean": 
            case "boolean": 
            case "Short": 
            case "short": 
            case "BigDecimal": 
            case "BigInteger": 
            case "Byte": 
            case "Character": 
            case "character": {
                return true;
            }
        }
        return false;
    }

    public static String javaTypeToOpenApiTypeConvert(String javaTypeName) {
        if (StringUtil.isEmpty((String)javaTypeName)) {
            return "object";
        }
        if (javaTypeName.length() == 1) {
            return "object";
        }
        if (javaTypeName.contains("[]")) {
            return "array";
        }
        switch (javaTypeName = javaTypeName.toLowerCase()) {
            case "java.lang.string": 
            case "string": 
            case "char": 
            case "date": 
            case "java.util.uuid": 
            case "uuid": 
            case "enum": 
            case "java.util.date": 
            case "localdatetime": 
            case "java.time.localdatetime": 
            case "java.time.year": 
            case "java.time.localtime": 
            case "java.time.yearmonth": 
            case "java.time.monthday": 
            case "java.time.localdate": 
            case "java.time.period": 
            case "localdate": 
            case "offsetdatetime": 
            case "localtime": 
            case "timestamp": 
            case "zoneddatetime": 
            case "period": 
            case "java.time.zoneddatetime": 
            case "java.time.offsetdatetime": 
            case "java.sql.timestamp": 
            case "java.lang.character": 
            case "character": 
            case "org.bson.types.objectid": {
                return "string";
            }
            case "java.util.list": 
            case "list": 
            case "java.util.set": 
            case "set": 
            case "java.util.linkedlist": 
            case "linkedlist": 
            case "java.util.arraylist": 
            case "arraylist": 
            case "java.util.treeset": 
            case "treeset": {
                return "array";
            }
            case "java.util.byte": 
            case "byte": 
            case "java.lang.integer": 
            case "integer": 
            case "int": 
            case "short": 
            case "java.lang.short": 
            case "int32": {
                return "integer";
            }
            case "double": 
            case "java.lang.long": 
            case "long": 
            case "java.lang.float": 
            case "float": 
            case "bigdecimal": 
            case "int64": 
            case "biginteger": {
                return "number";
            }
            case "java.lang.boolean": 
            case "boolean": {
                return "boolean";
            }
            case "multipartfile": 
            case "file": {
                return "file";
            }
        }
        return "object";
    }

    public static String getEscapeAndCleanComment(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            return "";
        }
        return comment.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getRequestMappingUrl(JavaAnnotation annotation) {
        return DocUtil.getPathUrl(annotation, "value", "name", "path");
    }

    public static String getPathUrl(JavaAnnotation annotation, String ... props) {
        for (String prop : props) {
            String url;
            AnnotationValue annotationValue = annotation.getProperty(prop);
            if (!Objects.nonNull(annotationValue) || !Objects.nonNull(url = DocUtil.resolveAnnotationValue(annotationValue))) continue;
            return url.toString();
        }
        return "";
    }

    public static String resolveAnnotationValue(AnnotationValue annotationValue) {
        FieldRef fieldRef;
        JavaField javaField;
        if (annotationValue instanceof Add) {
            Add add = (Add)annotationValue;
            String leftValue = DocUtil.resolveAnnotationValue(add.getLeft());
            String rightValue = DocUtil.resolveAnnotationValue(add.getRight());
            return StringUtil.removeQuotes((String)(leftValue + rightValue));
        }
        if (annotationValue instanceof FieldRef && (javaField = (fieldRef = (FieldRef)annotationValue).getField()) != null) {
            return StringUtil.removeQuotes((String)javaField.getInitializationExpression());
        }
        return Optional.ofNullable(annotationValue).map(Expression::getParameterValue).map(Object::toString).orElse("");
    }

    public static String handleRequestHeaderValue(JavaAnnotation annotation) {
        String header = DocUtil.getRequestHeaderValue(annotation);
        if (StringUtil.isEmpty((String)header)) {
            return header;
        }
        return StringUtil.removeDoubleQuotes((String)StringUtil.trimBlank((String)header));
    }

    public static String getRequestHeaderValue(JavaAnnotation annotation) {
        AnnotationValue annotationValue = annotation.getProperty("value");
        return DocUtil.resolveAnnotationValue(annotationValue);
    }

    public static List<ApiErrorCode> errorCodeDictToList(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        if (CollectionUtil.isNotEmpty(config.getErrorCodes())) {
            return config.getErrorCodes();
        }
        List<ApiErrorCodeDictionary> errorCodeDictionaries = config.getErrorCodeDictionaries();
        if (CollectionUtil.isEmpty(errorCodeDictionaries)) {
            return new ArrayList<ApiErrorCode>(0);
        }
        ClassLoader classLoader = config.getClassLoader();
        HashSet errorCodeList = new HashSet();
        try {
            for (ApiErrorCodeDictionary dictionary : errorCodeDictionaries) {
                Class<?> clzz = dictionary.getEnumClass();
                if (Objects.isNull(clzz)) {
                    if (StringUtil.isEmpty((String)dictionary.getEnumClassName())) {
                        throw new RuntimeException("Enum class name can't be null.");
                    }
                    clzz = classLoader.loadClass(dictionary.getEnumClassName());
                }
                Class<?> valuesResolverClass = null;
                if (StringUtil.isNotEmpty((String)dictionary.getValuesResolverClass())) {
                    valuesResolverClass = classLoader.loadClass(dictionary.getValuesResolverClass());
                }
                if (null != valuesResolverClass && DictionaryValuesResolver.class.isAssignableFrom(valuesResolverClass)) {
                    DictionaryValuesResolver resolver = (DictionaryValuesResolver)DocClassUtil.newInstance(valuesResolverClass);
                    errorCodeList.addAll(resolver.resolve());
                    errorCodeList.addAll(resolver.resolve(clzz));
                    continue;
                }
                if (clzz.isInterface()) {
                    Set<Class<? extends Enum>> enumImplementSet = dictionary.getEnumImplementSet();
                    if (CollectionUtil.isEmpty(enumImplementSet)) continue;
                    for (Class<? extends Enum> enumClass : enumImplementSet) {
                        JavaClass interfaceClass = javaProjectBuilder.getClassByName(enumClass.getCanonicalName());
                        if (Objects.nonNull(interfaceClass.getTagByName("ignore"))) continue;
                        List enumDictionaryList = EnumUtil.getEnumInformation(enumClass, (String)dictionary.getCodeField(), (String)dictionary.getDescField());
                        errorCodeList.addAll(enumDictionaryList);
                    }
                    continue;
                }
                JavaClass javaClass = javaProjectBuilder.getClassByName(clzz.getCanonicalName());
                if (Objects.nonNull(javaClass.getTagByName("ignore"))) continue;
                List enumDictionaryList = EnumUtil.getEnumInformation(clzz, (String)dictionary.getCodeField(), (String)dictionary.getDescField());
                errorCodeList.addAll(enumDictionaryList);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new ArrayList<ApiErrorCode>(errorCodeList);
    }

    public static List<ApiDocDict> buildDictionary(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        List<ApiDataDictionary> apiDataDictionaryList = config.getDataDictionaries();
        if (CollectionUtil.isEmpty(apiDataDictionaryList)) {
            return new ArrayList<ApiDocDict>(0);
        }
        ArrayList<ApiDocDict> apiDocDictList = new ArrayList<ApiDocDict>();
        try {
            ClassLoader classLoader = config.getClassLoader();
            int order = 0;
            for (ApiDataDictionary apiDataDictionary : apiDataDictionaryList) {
                ++order;
                Class<?> clazz = apiDataDictionary.getEnumClass();
                if (Objects.isNull(clazz)) {
                    if (StringUtil.isEmpty((String)apiDataDictionary.getEnumClassName())) {
                        throw new RuntimeException("Enum class name can't be null.");
                    }
                    clazz = classLoader.loadClass(apiDataDictionary.getEnumClassName());
                }
                if (clazz.isInterface()) {
                    Set<Class<? extends Enum>> enumImplementSet = apiDataDictionary.getEnumImplementSet();
                    if (CollectionUtil.isEmpty(enumImplementSet)) continue;
                    for (Class<? extends Enum> enumClass : enumImplementSet) {
                        JavaClass javaClass = javaProjectBuilder.getClassByName(enumClass.getCanonicalName());
                        if (Objects.nonNull(javaClass.getTagByName("ignore"))) continue;
                        DocletTag apiNoteTag = javaClass.getTagByName("apiNote");
                        ApiDocDict apiDocDict = new ApiDocDict();
                        apiDocDict.setOrder(order++);
                        apiDocDict.setTitle(javaClass.getComment());
                        apiDocDict.setDescription(DocUtil.getEscapeAndCleanComment(Optional.ofNullable(apiNoteTag).map(DocletTag::getValue).orElse("")));
                        List enumDictionaryList = EnumUtil.getEnumInformation(enumClass, (String)apiDataDictionary.getCodeField(), (String)apiDataDictionary.getDescField());
                        apiDocDict.setDataDictList(enumDictionaryList);
                        apiDocDictList.add(apiDocDict);
                    }
                    continue;
                }
                ApiDocDict apiDocDict = new ApiDocDict();
                apiDocDict.setOrder(order);
                apiDocDict.setTitle(apiDataDictionary.getTitle());
                JavaClass javaClass = javaProjectBuilder.getClassByName(clazz.getCanonicalName());
                if (Objects.nonNull(javaClass.getTagByName("ignore"))) continue;
                DocletTag apiNoteTag = javaClass.getTagByName("apiNote");
                apiDocDict.setDescription(DocUtil.getEscapeAndCleanComment(Optional.ofNullable(apiNoteTag).map(DocletTag::getValue).orElse("")));
                if (apiDataDictionary.getTitle() == null) {
                    apiDocDict.setTitle(javaClass.getComment());
                }
                List enumDictionaryList = EnumUtil.getEnumInformation(clazz, (String)apiDataDictionary.getCodeField(), (String)apiDataDictionary.getDescField());
                if (!clazz.isEnum()) {
                    throw new RuntimeException(clazz.getCanonicalName() + " is not an enum class.");
                }
                apiDocDict.setDataDictList(enumDictionaryList);
                apiDocDictList.add(apiDocDict);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return apiDocDictList;
    }

    public static String formatFieldTypeGicName(Map<String, String> genericMap, String[] globGicName, String fieldGicName) {
        String[] gNameArr;
        String gicName = "";
        for (String g : gNameArr = DocClassUtil.getSimpleGicName(fieldGicName)) {
            if (g.length() != 1) continue;
            if (Objects.nonNull(genericMap.get(g))) {
                gicName = genericMap.get(g);
            }
            if (!StringUtil.isNotEmpty((String)gicName)) continue;
            fieldGicName = fieldGicName.replace(g, gicName);
        }
        return fieldGicName;
    }

    public static String handleConstants(Map<String, String> constantsMap, String value) {
        String constantsValue = constantsMap.get(value);
        if (Objects.nonNull(constantsValue)) {
            return constantsValue.toString();
        }
        return value;
    }

    public static String handleContentType(String mediaType, JavaAnnotation annotation, String annotationName) {
        String annotationValue;
        if (("jakarta.ws.rs.Produces".equals(annotationName) || "javax.ws.rs.Produces".equals(annotationName)) && ("MediaType.APPLICATION_JSON".equals(annotationValue = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(annotation))) || "application/json".equals(annotationValue) || "MediaType.TEXT_PLAIN".equals(annotationValue) || "text/plain".equals(annotationValue))) {
            mediaType = "application/json";
        }
        return mediaType;
    }

    public static boolean filterPath(RequestMapping requestMapping, ApiReqParam apiReqHeader) {
        if (StringUtil.isEmpty((String)apiReqHeader.getPathPatterns()) && StringUtil.isEmpty((String)apiReqHeader.getExcludePathPatterns())) {
            return true;
        }
        return DocPathUtil.matches(requestMapping.getShortUrl(), apiReqHeader.getPathPatterns(), apiReqHeader.getExcludePathPatterns());
    }

    public static String paramCommentResolve(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            comment = "No comments found.";
        } else if (comment.contains("|")) {
            comment = comment.substring(0, comment.indexOf("|"));
        }
        return comment;
    }

    public static String delPropertiesUrl(String value, Set<String> visitedPlaceholders) {
        int startIndex = value.indexOf("${");
        if (startIndex == -1) {
            return value;
        }
        StringBuilder result = new StringBuilder(value);
        while (startIndex != -1) {
            int endIndex = DocUtil.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder;
                String originalPlaceholder = placeholder = result.substring(startIndex + "${".length(), endIndex);
                if (visitedPlaceholders == null) {
                    visitedPlaceholders = new HashSet<String>(4);
                }
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                String propVal = SystemPlaceholders.replaceSystemProperties(placeholder = DocUtil.delPropertiesUrl(placeholder, visitedPlaceholders));
                if (propVal == null && (separatorIndex = placeholder.indexOf(":")) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + ":".length());
                    propVal = SystemPlaceholders.replaceSystemProperties(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (propVal != null) {
                    propVal = DocUtil.delPropertiesUrl(propVal, visitedPlaceholders);
                    result.replace(startIndex - 1, endIndex + "${".length() - 1, propVal);
                    startIndex = result.indexOf("${", startIndex + propVal.length());
                } else {
                    startIndex = result.indexOf("${", endIndex + "${".length());
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private static int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + "${".length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (DocUtil.substringMatch(buf, index, "}")) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += "}".length();
                    continue;
                }
                return index;
            }
            if (DocUtil.substringMatch(buf, index, "{")) {
                ++withinNestedPlaceholder;
                index += "{".length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static List<String> splitPathBySlash(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return new ArrayList<String>(0);
        }
        String[] result = url.split("/");
        ArrayList<String> path = new ArrayList<String>();
        for (int i = 0; i < result.length; ++i) {
            if (StringUtil.isEmpty((String)result[i])) continue;
            if (i < result.length - 1) {
                if (result[i].startsWith("${") && !result[i].endsWith("}") && !result[i + 1].startsWith("${") && result[i + 1].endsWith("}")) {
                    String merged = result[i] + "/" + result[i + 1];
                    path.add(merged);
                    ++i;
                    continue;
                }
                path.add(result[i]);
                continue;
            }
            path.add(result[i]);
        }
        return path;
    }

    static {
        fieldValue.put("uuid-string", UUID.randomUUID().toString());
        fieldValue.put("traceid-string", UUID.randomUUID().toString());
        fieldValue.put("id-string", String.valueOf(RandomUtil.randomInt((int)1, (int)200)));
        fieldValue.put("ids-string", String.valueOf(RandomUtil.randomInt((int)1, (int)200)));
        fieldValue.put("nickname-string", enFaker.name().username());
        fieldValue.put("hostname-string", faker.internet().ipV4Address());
        fieldValue.put("name-string", faker.name().username());
        fieldValue.put("author-string", faker.book().author());
        fieldValue.put("url-string", faker.internet().url());
        fieldValue.put("username-string", faker.name().username());
        fieldValue.put("code-int", "0");
        fieldValue.put("index-int", "1");
        fieldValue.put("index-integer", "1");
        fieldValue.put("page-int", "1");
        fieldValue.put("page-integer", "1");
        fieldValue.put("age-int", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("age-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("email-string", faker.internet().emailAddress());
        fieldValue.put("domain-string", faker.internet().domainName());
        fieldValue.put("phone-string", faker.phoneNumber().cellPhone());
        fieldValue.put("mobile-string", faker.phoneNumber().cellPhone());
        fieldValue.put("telephone-string", faker.phoneNumber().phoneNumber());
        fieldValue.put("address-string", faker.address().fullAddress().replace(",", "\uff0c"));
        fieldValue.put("ip-string", faker.internet().ipV4Address());
        fieldValue.put("ipv4-string", faker.internet().ipV4Address());
        fieldValue.put("ipv6-string", faker.internet().ipV6Address());
        fieldValue.put("company-string", faker.company().name());
        fieldValue.put("timestamp-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("timestamp-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("time-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("time-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("birthday-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("birthday-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("code-string", String.valueOf(RandomUtil.randomInt((int)100, (int)99999)));
        fieldValue.put("message-string", "success,fail".split(",")[RandomUtil.randomInt((int)0, (int)1)]);
        fieldValue.put("date-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("date-date", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("begintime-date", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("endtime-date", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("time-localtime", LocalDateTime.now().toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        fieldValue.put("state-int", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("state-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-int", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)10)));
        fieldValue.put("flag-boolean", "true");
        fieldValue.put("flag-Boolean", "false");
        fieldValue.put("idcard-string", IDCardUtil.getIdCard());
        fieldValue.put("sex-int", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("sex-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("gender-int", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("gender-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)2)));
        fieldValue.put("limit-int", "10");
        fieldValue.put("limit-integer", "10");
        fieldValue.put("size-int", "10");
        fieldValue.put("size-integer", "10");
        fieldValue.put("offset-int", "1");
        fieldValue.put("offset-integer", "1");
        fieldValue.put("offset-long", "1");
        fieldValue.put("version-string", enFaker.app().version());
        patternCache = new HashMap<String, Pattern>();
        filterMethodCache = new HashMap<String, Set<String>>();
    }
}

