/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.ApiReqParamInTypeEnum;
import com.power.doc.constants.MediaType;
import com.power.doc.constants.Methods;
import com.power.doc.handler.IHeaderHandler;
import com.power.doc.handler.IRequestMappingHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.DocJavaParameter;
import com.power.doc.model.DocMapping;
import com.power.doc.model.FormData;
import com.power.doc.model.annotation.EntryAnnotation;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.annotation.MappingAnnotation;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.CurlRequest;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IBaseDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.CurlUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.power.doc.utils.TornaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface IRestDocTemplate
extends IBaseDocBuildTemplate {
    public static final Logger log = Logger.getLogger(IRestDocTemplate.class.getName());
    public static final AtomicInteger atomicInteger = new AtomicInteger(1);

    default public List<ApiDoc> processApiData(ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, List<ApiReqParam> configApiReqParams, IRequestMappingHandler baseMappingHandler, IHeaderHandler headerHandler) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        List<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        boolean setCustomOrder = false;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        for (JavaClass cls : classes) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls)) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.defaultEntryPoint(cls, frameworkAnnotations) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildEntryPointMethod(cls, apiConfig, projectBuilder, frameworkAnnotations, configApiReqParams, baseMappingHandler, headerHandler);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        apiDocList = this.handleTagsApiDoc(apiDocList);
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    default public String createDocRenderHeaders(List<ApiReqParam> headers, boolean isAdoc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqParam>(0);
        }
        for (ApiReqParam header : headers) {
            builder.append("|").append(header.getName()).append("|").append(header.getType()).append("|").append(header.isRequired()).append("|").append(header.getDesc()).append("|").append(header.getSince()).append("|\n");
        }
        return builder.toString();
    }

    default public void handleApiDoc(JavaClass cls, List<ApiDoc> apiDocList, List<ApiMethodDoc> apiMethodDocs, int order, boolean isUseMD5) {
        String controllerName = cls.getName();
        ApiDoc apiDoc = new ApiDoc();
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        apiDoc.setOrder(order);
        apiDoc.setName(controllerName);
        apiDoc.setAuthor(classAuthor);
        apiDoc.setAlias(controllerName);
        apiDoc.setFolder(true);
        apiDoc.setPackageName(cls.getPackage().getName());
        List classTags = cls.getTagsByName("tag");
        Set tagSet = classTags.stream().map(DocletTag::getValue).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
        String[] tags = tagSet.toArray(new String[0]);
        apiDoc.setTags(tags);
        if (isUseMD5) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        String desc = DocUtil.getEscapeAndCleanComment(cls.getComment());
        apiDoc.setDesc(desc);
        apiDoc.setList(apiMethodDocs);
        apiDocList.add(apiDoc);
        tagSet.add(StringUtils.trim((String)desc));
        for (String tag : tagSet) {
            DocMapping.tagDocPut(tag, apiDoc, null);
            for (ApiMethodDoc methodDoc : apiMethodDocs) {
                DocMapping.tagDocPut(tag, null, methodDoc);
            }
        }
        for (ApiMethodDoc methodDoc : apiMethodDocs) {
            Object[] docTags = methodDoc.getTags();
            methodDoc.setClazzDoc(apiDoc);
            if (ArrayUtils.isEmpty((Object[])docTags)) continue;
            for (Object tag : docTags) {
                DocMapping.tagDocPut((String)tag, null, methodDoc);
            }
        }
    }

    default public void mappingParamToApiParam(String str, List<ApiParam> paramList, Map<String, String> mappingParams) {
        String paramValue;
        String paramName;
        String param = StringUtil.removeQuotes((String)str);
        String description = "Parameter condition.";
        if (param.contains("=")) {
            int index = param.indexOf("=");
            paramName = param.substring(0, index);
            paramValue = param.substring(index + 1);
            description = description + " [" + paramName + "=" + paramValue + "]";
        } else {
            paramName = param;
            paramValue = DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE);
        }
        String type = ValidateUtil.isPositiveInteger((String)paramValue) ? "int32" : "string";
        ApiParam apiParam = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setQueryParam(true).setValue(paramValue).setType(type).setDesc(description).setRequired(true).setVersion("-");
        paramList.add(apiParam);
        mappingParams.put(paramName, null);
    }

    default public void mappingParamProcess(String str, Map<String, String> pathParamsMap) {
        String param = StringUtil.removeQuotes((String)str);
        if (param.contains("=")) {
            int index = param.indexOf("=");
            String paramName = param.substring(0, index);
            String paramValue = param.substring(index + 1);
            pathParamsMap.put(paramName, paramValue);
        } else {
            String paramName = param;
            pathParamsMap.put(paramName, DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE));
        }
    }

    default public String getParamName(String paramName, JavaAnnotation annotation) {
        String resolvedParamName = DocUtil.resolveAnnotationValue(annotation.getProperty("value"));
        if (StringUtils.isBlank((CharSequence)resolvedParamName)) {
            resolvedParamName = DocUtil.resolveAnnotationValue(annotation.getProperty("name"));
        }
        if (!StringUtils.isBlank((CharSequence)resolvedParamName)) {
            paramName = StringUtil.removeQuotes((String)resolvedParamName);
        }
        return StringUtil.removeQuotes((String)paramName);
    }

    default public List<ApiDoc> handleTagsApiDoc(List<ApiDoc> apiDocList) {
        if (CollectionUtil.isEmpty(apiDocList)) {
            return Collections.emptyList();
        }
        HashMap copyMap = new HashMap();
        apiDocList.forEach(doc -> {
            Object[] tags = doc.getTags();
            if (ArrayUtils.isEmpty((Object[])tags)) {
                tags = new String[]{doc.getPackageName() + "." + doc.getName()};
            }
            for (Object tag : tags) {
                tag = StringUtil.trim((String)tag);
                copyMap.computeIfPresent(tag, (k, v) -> {
                    List<Object> list = CollectionUtil.isEmpty(v.getList()) ? new ArrayList() : v.getList();
                    list.addAll(doc.getList());
                    v.setList(list);
                    return v;
                });
                copyMap.putIfAbsent(tag, doc);
            }
        });
        HashMap<String, ApiDoc> allMap = new HashMap<String, ApiDoc>(copyMap);
        allMap.forEach((k, v) -> {
            List<ApiMethodDoc> methodDocList = v.getList();
            methodDocList.forEach(method -> {
                Object[] tags = method.getTags();
                if (ArrayUtils.isEmpty((Object[])tags)) {
                    return;
                }
                for (Object tag : tags) {
                    tag = StringUtil.trim((String)tag);
                    copyMap.computeIfPresent(tag, (k1, v2) -> {
                        method.setOrder(v2.getList().size() + 1);
                        v2.getList().add((ApiMethodDoc)method);
                        return v2;
                    });
                    copyMap.putIfAbsent(tag, ApiDoc.buildTagApiDoc(v, (String)tag, method));
                }
            });
        });
        ArrayList<ApiDoc> apiDocs = new ArrayList<ApiDoc>(copyMap.values());
        int index = apiDocs.size() - 1;
        for (ApiDoc apiDoc : apiDocs) {
            if (apiDoc.getOrder() != null) continue;
            apiDoc.setOrder(index++);
        }
        apiDocs.sort(Comparator.comparing(ApiDoc::getOrder));
        return apiDocs;
    }

    default public List<JavaAnnotation> getClassAnnotations(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>(cls.getAnnotations());
        Map<String, EntryAnnotation> mappingAnnotationMap = frameworkAnnotations.getEntryAnnotations();
        boolean flag = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            String fullyName = item.getType().getFullyQualifiedName();
            return mappingAnnotationMap.containsKey(annotationName) || mappingAnnotationMap.containsKey(fullyName);
        });
        if (flag) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            annotationsList.addAll(this.getClassAnnotations(superJavaClass, frameworkAnnotations));
        }
        return annotationsList;
    }

    default public List<ApiMethodDoc> buildEntryPointMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, List<ApiReqParam> configApiReqParams, IRequestMappingHandler baseMappingHandler, IHeaderHandler headerHandler) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        List<JavaAnnotation> classAnnotations = this.getClassAnnotations(cls, frameworkAnnotations);
        String baseUrl = "";
        String classMediaType = null;
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            Object consumes;
            String annotationName = annotation.getType().getValue();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (Objects.isNull(mappingAnnotation)) continue;
            if (CollectionUtil.isNotEmpty(mappingAnnotation.getPathProps())) {
                baseUrl = StringUtil.removeQuotes((String)DocUtil.getPathUrl(annotation, mappingAnnotation.getPathProps().toArray(new String[0])));
            }
            if (classMediaType != null || (consumes = annotation.getNamedParameter(mappingAnnotation.getConsumesProp())) == null) continue;
            classMediaType = consumes.toString();
        }
        Set<String> filterMethods = DocUtil.findFilterMethods(clazName);
        boolean needAllMethods = filterMethods.contains("*");
        List methods = cls.getMethods();
        List<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (Object method : methods) {
            if (method.isPrivate() || DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), clazName + "." + method.getName()) || Objects.nonNull(method.getTagByName("ignore")) || !needAllMethods && !filterMethods.contains(method.getName())) continue;
            docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, (JavaMethod)method, null));
        }
        docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, cls));
        List implClasses = cls.getImplements();
        for (JavaType type : implClasses) {
            JavaClass javaClass2 = (JavaClass)type;
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaClass2);
            for (JavaMethod method : javaClass2.getMethods()) {
                if (!method.isDefault()) continue;
                docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, actualTypesMap));
            }
        }
        if (apiConfig.getCustomJavaMethodHandler() != null) {
            docJavaMethods = apiConfig.getCustomJavaMethodHandler().apply(cls, docJavaMethods);
        }
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            JavaMethod method = docJavaMethod.getJavaMethod();
            RequestMapping requestMapping = baseMappingHandler.handle(projectBuilder, baseUrl, method, frameworkAnnotations, (javaClass, mapping) -> this.requestMappingPostProcess(javaClass, method, mapping));
            if (Objects.isNull(requestMapping) || Objects.isNull(requestMapping.getShortUrl())) continue;
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            String mediaType = requestMapping.getMediaType();
            if (Objects.nonNull(mediaType)) {
                apiMethodDoc.setContentType(MediaType.valueOf(mediaType));
            } else if (Objects.nonNull(classMediaType)) {
                apiMethodDoc.setContentType(MediaType.valueOf(classMediaType));
            }
            apiMethodDoc.setDownload(docJavaMethod.isDownload());
            apiMethodDoc.setPage(docJavaMethod.getPage());
            apiMethodDoc.setGroup(group);
            apiMethodDoc.setVersion(docJavaMethod.getVersion());
            if (Objects.nonNull(docJavaMethod.getGroup())) {
                apiMethodDoc.setGroup(docJavaMethod.getGroup());
            }
            List tags = method.getTagsByName("tag");
            apiMethodDoc.setTags((String[])tags.stream().map(DocletTag::getValue).toArray(String[]::new));
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setDesc(method.getComment());
            apiMethodDoc.setAuthor(docJavaMethod.getAuthor());
            apiMethodDoc.setDetail(docJavaMethod.getDetail());
            String methodUid = DocUtil.generateId(clazName + method.getName() + methodOrder);
            apiMethodDoc.setMethodId(methodUid);
            List<ApiReqParam> apiReqHeaders = headerHandler.handle(method, projectBuilder);
            apiReqHeaders = apiReqHeaders.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            apiMethodDoc.setDeprecated(requestMapping.isDeprecated());
            List<ApiReqParam> apiReqParamList = configApiReqParams.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder, apiReqParamList, frameworkAnnotations);
            apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
            apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
            apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            if (paramsDataToTree) {
                this.convertParamsDataToTree(apiMethodDoc);
            }
            Map<String, List<ApiReqParam>> reqParamMap = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn));
            List headerParamList = reqParamMap.getOrDefault(ApiReqParamInTypeEnum.HEADER.getValue(), Collections.emptyList());
            List<ApiReqParam> allApiReqHeaders = Stream.of(headerParamList, apiReqHeaders).filter(Objects::nonNull).flatMap(Collection::stream).distinct().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            String path = apiMethodDoc.getPath().split(";")[0];
            String pathUrl = DocUtil.formatPathUrl(path);
            List<ApiParam> pathParams = apiMethodDoc.getPathParams();
            Iterator<ApiParam> pathIterator = pathParams.iterator();
            while (pathIterator.hasNext()) {
                ApiParam next = pathIterator.next();
                String pathKey = "{" + next.getField() + "}";
                if (pathUrl.contains(pathKey)) continue;
                pathIterator.remove();
            }
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, requestMapping.getMethodType(), projectBuilder, frameworkAnnotations);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                responseValue = responseValue.replaceAll("<br>", "");
                apiMethodDoc.setResponseUsage(JsonUtil.toPrettyFormat(responseValue));
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            TornaUtil.setTornaArrayTags(docJavaMethod.getJavaMethod(), apiMethodDoc);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    default public ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder, List<ApiReqParam> configApiReqParams, FrameworkAnnotations frameworkAnnotations) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        boolean isStrict = builder.getApiConfig().isStrict();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        Map<String, String> paramsComments = docJavaMethod.getParamsComments();
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        HashMap<String, String> mappingParams = new HashMap<String, String>();
        List methodAnnotations = javaMethod.getAnnotations();
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (!Objects.nonNull(mappingAnnotation) || !StringUtil.isNotEmpty((String)mappingAnnotation.getParamsProp()) || Objects.isNull(paramsObjects = annotation.getNamedParameter(mappingAnnotation.getParamsProp()))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamToApiParam(paramsObjects.toString(), paramList, mappingParams);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamToApiParam(str, paramList, mappingParams);
            }
        }
        Map<String, Map<String, ApiReqParam>> collect = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn, Collectors.toMap(ApiReqParam::getName, m -> m, (k1, k2) -> k1)));
        Map<String, ApiReqParam> pathReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.PATH.getValue(), Collections.emptyMap());
        Map<String, ApiReqParam> queryReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.QUERY.getValue(), Collections.emptyMap());
        List<DocJavaParameter> parameterList = this.getJavaParameterList(builder, docJavaMethod, frameworkAnnotations);
        if (parameterList.isEmpty()) {
            AtomicInteger querySize = new AtomicInteger(paramList.size() + 1);
            paramList.addAll(queryReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setQueryParam(true).setId(querySize.getAndIncrement())).collect(Collectors.toList()));
            AtomicInteger pathSize = new AtomicInteger(1);
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(pathReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setPathParam(true).setId(pathSize.getAndIncrement())).collect(Collectors.toList()))).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        int requestBodyCounter = 0;
        block2: for (DocJavaParameter apiParameter : parameterList) {
            Map<String, Object> map;
            String[] gicNameArr;
            boolean queryParam;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            if (mappingParams.containsKey(paramName)) continue;
            String typeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            String simpleName = simpleTypeName.toLowerCase();
            String fullTypeName = apiParameter.getFullyQualifiedName();
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            String strRequired = "false";
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            boolean required = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if (this.ignoreMvcParamWithAnnotation(annotationName)) continue block2;
                if (frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().equals(annotationName) || frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().equals(annotationName)) {
                    AnnotationValue annotationDefaultVal;
                    String defaultValueProp = "defaultValue";
                    String requiredProp = "required";
                    if (frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().equals(annotationName)) {
                        defaultValueProp = frameworkAnnotations.getRequestParamAnnotation().getDefaultValueProp();
                        requiredProp = frameworkAnnotations.getRequestParamAnnotation().getRequiredProp();
                    }
                    if (frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().equals(annotationName)) {
                        defaultValueProp = frameworkAnnotations.getPathVariableAnnotation().getDefaultValueProp();
                        requiredProp = frameworkAnnotations.getPathVariableAnnotation().getRequiredProp();
                        isPathVariable = true;
                    }
                    if (Objects.nonNull(annotationDefaultVal = annotation.getProperty(defaultValueProp))) {
                        mockValue = DocUtil.resolveAnnotationValue(annotationDefaultVal);
                    }
                    paramName = this.getParamName(paramName, annotation);
                    AnnotationValue annotationRequired = annotation.getProperty(requiredProp);
                    strRequired = Objects.nonNull(annotationRequired) ? annotationRequired.toString() : "true";
                }
                if (JavaClassValidateUtil.isJSR303Required(annotationName)) {
                    strRequired = "true";
                }
                if (frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName)) {
                    mockValue = JsonBuildHelper.buildJson(fullTypeName, typeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, builder);
                    ++requestBodyCounter;
                    isRequestBody = true;
                }
                required = Boolean.parseBoolean(strRequired);
            }
            comment.append(JavaFieldUtil.getJsrComment(annotations));
            if (requestFieldToUnderline && !isPathVariable) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            if (JavaClassValidateUtil.isFile(typeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setDesc(comment.toString());
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment.append("(array of file)");
                    param.setType("file");
                    param.setDesc(comment.toString());
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            boolean bl = queryParam = !isRequestBody && !isPathVariable;
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                Map<String, Object> map2;
                ApiParam param;
                JavaClass gicJavaClass;
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                String gicName = gicNameArr[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (StringUtil.isNotEmpty((String)(mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName))) && !mockValue.contains(",")) {
                    mockValue = StringUtils.join((Object[])new String[]{mockValue, ",", JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName)});
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setEnumValues(JavaClassUtil.getEnumValues(gicJavaClass)).setEnumInfo(JavaClassUtil.getEnumInfo(gicJavaClass, builder)).setType("array").setValue(String.valueOf(value));
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setVersion("-").setValue(mockValue);
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isFile(gicName)) {
                    ApiParam param2 = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setHasItems(true).setDesc(comment + "(array of file)");
                    paramList.add(param2);
                    continue;
                }
                if (requestBodyCounter <= 0) continue;
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.TRUE, null));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment.toString()).setRequired(required).setVersion("-");
                paramList.add(param);
                if (requestBodyCounter <= 0) continue;
                map = OpenApiSchemaUtil.primaryTypeSchema(simpleName);
                docJavaMethod.setRequestSchema(map);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    map = OpenApiSchemaUtil.mapTypeSchema("object");
                    docJavaMethod.setRequestSchema(map);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map3 = OpenApiSchemaUtil.mapTypeSchema(gicNameArr[1]);
                    docJavaMethod.setRequestSchema(map3);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, null));
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, isPathVariable || queryParam);
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumInfo(JavaClassUtil.getEnumInfo(javaClass, builder)).setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, null));
        }
        return ApiParamTreeUtil.buildMethodReqParam(paramList, queryReqParamMap, pathReqParamMap, requestBodyCounter);
    }

    default public ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder, FrameworkAnnotations frameworkAnnotations) {
        String exampleBody;
        CurlRequest curlRequest;
        String url;
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> queryParamsMap = new LinkedHashMap<String, String>();
        apiMethodDoc.getPathParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> pathParamsMap.put(param.getSourceField(), param.getValue()));
        apiMethodDoc.getQueryParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> queryParamsMap.put(param.getSourceField(), param.getValue()));
        List methodAnnotations = method.getAnnotations();
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (!Objects.nonNull(mappingAnnotation) || !StringUtil.isNotEmpty((String)mappingAnnotation.getParamsProp()) || Objects.isNull(paramsObjects = annotation.getNamedParameter(mappingAnnotation.getParamsProp()))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamProcess(paramsObjects.toString(), queryParamsMap);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamProcess(str, queryParamsMap);
            }
        }
        List<DocJavaParameter> parameterList = this.getJavaParameterList(configBuilder, javaMethod, frameworkAnnotations);
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.size() < 1) {
            String path = apiMethodDoc.getPath().split(";")[0];
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String url2 = UrlUtil.urlJoin((String)path, queryParamsMap);
            url2 = StringUtil.removeQuotes((String)url2);
            url2 = apiMethodDoc.getServerUrl() + "/" + url2;
            url2 = UrlUtil.simplifyUrl((String)url2);
            CurlRequest curlRequest2 = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url2);
            String format = CurlUtil.toCurl(curlRequest2);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> paramsComments = DocUtil.getCommentsByTag(method, "param", null);
        List<String> mvcRequestAnnotations = this.listMvcRequestAnnotations();
        List<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        block2: for (DocJavaParameter apiParameter : parameterList) {
            FormData formData;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            String typeName = apiParameter.getFullyQualifiedName();
            String gicTypeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicTypeName, simpleTypeName);
            if (queryParamsMap.containsKey(paramName)) {
                mockValue = (String)queryParamsMap.get(paramName);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, configBuilder.getJavaProjectBuilder());
            boolean paramAdded = false;
            boolean requestParam = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                String fullName = annotation.getType().getSimpleName();
                if (!mvcRequestAnnotations.contains(fullName) || paramAdded) continue;
                if (this.ignoreMvcParamWithAnnotation(annotationName)) continue block2;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (Objects.nonNull(annotationDefaultVal)) {
                    mockValue = DocUtil.resolveAnnotationValue(annotationDefaultVal);
                }
                paramName = this.getParamName(paramName, annotation);
                if (frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName)) {
                    if (apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded;charset=UTF-8")) {
                        apiMethodDoc.setContentType("application/json");
                    }
                    boolean isArrayOrCollection = false;
                    if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                        simpleTypeName = globGicName[0];
                        isArrayOrCollection = true;
                    }
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        if (isArrayOrCollection) {
                            mockValue = StringUtil.isNotEmpty((String)mockValue) ? "[" + mockValue + "]" : "[" + DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName) + "]";
                            mockValue = JsonUtil.toPrettyFormat(mockValue);
                        }
                        requestExample.setJsonBody(mockValue).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, configBuilder);
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
                    }
                    queryParamsMap.remove(paramName);
                    paramAdded = true;
                    continue;
                }
                if (frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().contains(annotationName)) {
                    if (javaClass.isEnum()) {
                        Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                    }
                    if (pathParamsMap.containsKey(paramName)) {
                        mockValue = (String)pathParamsMap.get(paramName);
                    }
                    pathParamsMap.put(paramName, mockValue);
                    paramAdded = true;
                    continue;
                }
                if (!frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                if (queryParamsMap.containsKey(paramName)) {
                    mockValue = (String)queryParamsMap.get(paramName);
                }
                if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                    requestExample.addJsonBody(mockValue);
                }
                if (JavaClassValidateUtil.isFile(typeName)) break;
                queryParamsMap.put(paramName, mockValue);
                requestParam = true;
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (JavaClassValidateUtil.isFile(gicTypeName)) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    formData.setType("file");
                    formData.setHasItems(true);
                }
                formData.setDescription(comment);
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(typeName) && !requestParam) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDescription(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                    throw new RuntimeException("can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                JavaClass javaClass1 = configBuilder.getClassByName(gicName);
                String value = Objects.nonNull(javaClass1) && javaClass1.isEnum() ? String.valueOf(JavaClassUtil.getEnumValue(javaClass1, Boolean.TRUE)) : RandomUtil.randomValueByType((String)gicName);
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDescription(comment);
                formData2.setType("text");
                formData2.setValue(value);
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDescription(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
        }
        boolean hasFormDataUploadFile = formDataList.stream().anyMatch(form -> Objects.equals(form.getType(), "file"));
        Map<Boolean, List<FormData>> formDataGroupMap = formDataList.stream().collect(Collectors.groupingBy(e -> Objects.equals(e.getType(), "file")));
        List fileFormDataList = formDataGroupMap.getOrDefault(Boolean.TRUE, new ArrayList());
        if (hasFormDataUploadFile) {
            formDataList = formDataGroupMap.getOrDefault(Boolean.FALSE, new ArrayList());
            apiMethodDoc.setContentType("multipart/form-data");
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        Map<String, String> formDataToMap = DocUtil.formDataToMap(formDataList);
        queryParamsMap.putAll(formDataToMap);
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", queryParamsMap).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            url = this.formatRequestUrl(pathParamsMap, queryParamsMap, apiMethodDoc.getServerUrl(), path);
            curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody(requestExample.isJson() ? requestExample.getJsonBody() : "").setUrl(url);
        }
        return requestExample;
    }

    default public boolean defaultEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        if (Objects.isNull(frameworkAnnotations)) {
            return false;
        }
        List<JavaAnnotation> classAnnotations = DocClassUtil.getAnnotations(cls);
        Map<String, EntryAnnotation> entryAnnotationMap = frameworkAnnotations.getEntryAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getValue();
            if (entryAnnotationMap.containsKey(name)) {
                return true;
            }
            if (!this.isEntryPoint(cls, frameworkAnnotations)) continue;
            return true;
        }
        return false;
    }

    default public List<DocJavaMethod> getParentsClassMethods(ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, JavaClass cls) {
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>();
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            for (JavaMethod method : parentMethodList) {
                docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, actualTypesMap));
            }
            docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, parentClass));
        }
        return docJavaMethods;
    }

    default public DocJavaMethod convertToDocJavaMethod(ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, JavaMethod method, Map<String, JavaType> actualTypesMap) {
        DocletTag docletTag;
        JavaClass cls = method.getDeclaringClass();
        String clzName = cls.getCanonicalName();
        if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
            throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
        }
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        DocJavaMethod docJavaMethod = DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap);
        if (Objects.nonNull(method.getTagByName("download"))) {
            docJavaMethod.setDownload(true);
        }
        DocletTag pageTag = method.getTagByName("page");
        if (Objects.nonNull(method.getTagByName("page"))) {
            String pageUrl = projectBuilder.getServerUrl() + "/" + pageTag.getValue();
            docJavaMethod.setPage(UrlUtil.simplifyUrl((String)pageUrl));
        }
        if (Objects.nonNull(docletTag = method.getTagByName("group"))) {
            docJavaMethod.setGroup(docletTag.getValue());
        }
        docJavaMethod.setParamTagMap(DocUtil.getCommentsByTag(method, "param", clzName));
        docJavaMethod.setParamsComments(DocUtil.getCommentsByTag(method, "param", null));
        Map<String, String> authorMap = DocUtil.getCommentsByTag(method, "author", cls.getName());
        String authorValue = String.join((CharSequence)", ", new ArrayList<String>(authorMap.keySet()));
        if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
            docJavaMethod.setAuthor(JsonUtil.toPrettyFormat(authorValue));
        }
        if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
            docJavaMethod.setAuthor(classAuthor);
        }
        String comment = DocUtil.getEscapeAndCleanComment(method.getComment());
        docJavaMethod.setDesc(comment);
        String version = DocUtil.getNormalTagComments(method, "since", cls.getName());
        docJavaMethod.setVersion(version);
        String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
        if (StringUtil.isEmpty((String)apiNoteValue)) {
            apiNoteValue = method.getComment();
        }
        docJavaMethod.setDetail(apiNoteValue != null ? apiNoteValue : "");
        return docJavaMethod;
    }

    public boolean isEntryPoint(JavaClass var1, FrameworkAnnotations var2);

    public List<String> listMvcRequestAnnotations();

    public void requestMappingPostProcess(JavaClass var1, JavaMethod var2, RequestMapping var3);

    public boolean ignoreMvcParamWithAnnotation(String var1);
}

