/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.RpcJavaMethod;
import com.power.doc.template.IBaseDocBuildTemplate;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface IRpcDocTemplate
extends IBaseDocBuildTemplate {
    default public RpcJavaMethod convertToRpcJavaMethod(ApiConfig apiConfig, JavaMethod method, Map<String, JavaType> actualTypesMap) {
        JavaClass cls = method.getDeclaringClass();
        RpcJavaMethod rpcJavaMethod = new RpcJavaMethod();
        rpcJavaMethod.setJavaMethod(method);
        rpcJavaMethod.setName(method.getName());
        rpcJavaMethod.setActualTypesMap(actualTypesMap);
        String methodDefine = this.methodDefinition(method, actualTypesMap);
        String scapeMethod = methodDefine.replaceAll("<", "&lt;");
        scapeMethod = scapeMethod.replaceAll(">", "&gt;");
        rpcJavaMethod.setMethodDefinition(methodDefine);
        rpcJavaMethod.setEscapeMethodDefinition(scapeMethod);
        rpcJavaMethod.setDesc(DocUtil.getEscapeAndCleanComment(method.getComment()));
        String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
        if (StringUtil.isEmpty((String)apiNoteValue)) {
            apiNoteValue = method.getComment();
        }
        String version = DocUtil.getNormalTagComments(method, "since", cls.getName());
        rpcJavaMethod.setVersion(version);
        rpcJavaMethod.setDetail(apiNoteValue != null ? apiNoteValue : "");
        String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
        if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
            rpcJavaMethod.setAuthor(authorValue);
        }
        List annotations = method.getAnnotations();
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            if (!"Deprecated".equals(annotationName)) continue;
            rpcJavaMethod.setDeprecated(true);
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            rpcJavaMethod.setDeprecated(true);
        }
        return rpcJavaMethod;
    }

    default public String methodDefinition(JavaMethod method, Map<String, JavaType> actualTypesMap) {
        String[] arrays;
        StringBuilder methodBuilder = new StringBuilder();
        JavaType returnType = method.getReturnType();
        String simpleReturn = this.replaceTypeName(returnType.getCanonicalName(), actualTypesMap, Boolean.TRUE);
        String returnClass = this.replaceTypeName(returnType.getGenericCanonicalName(), actualTypesMap, Boolean.TRUE);
        returnClass = returnClass.replace(simpleReturn, JavaClassUtil.getClassSimpleName(simpleReturn));
        for (String str : arrays = DocClassUtil.getSimpleGicName(returnClass)) {
            String[] generics;
            if (str.contains("[")) {
                str = str.substring(0, str.indexOf("["));
            }
            for (String generic : generics = str.split("[<,]")) {
                if (generic.contains("extends")) {
                    String className = generic.substring(generic.lastIndexOf(" ") + 1);
                    returnClass = returnClass.replace(className, JavaClassUtil.getClassSimpleName(className));
                }
                if (generic.length() == 1 || generic.contains("extends")) continue;
                returnClass = returnClass.replaceAll(generic, JavaClassUtil.getClassSimpleName(generic));
            }
        }
        methodBuilder.append(returnClass).append(" ");
        ArrayList<String> params = new ArrayList<String>();
        List parameters = method.getParameters();
        for (JavaParameter parameter : parameters) {
            String typeName = this.replaceTypeName(parameter.getType().getGenericValue(), actualTypesMap, Boolean.TRUE);
            params.add(typeName + " " + parameter.getName());
        }
        methodBuilder.append(method.getName()).append("(").append(String.join((CharSequence)", ", params)).append(")");
        return methodBuilder.toString();
    }

    default public List<RpcJavaMethod> getParentsClassMethods(ApiConfig apiConfig, JavaClass cls) {
        ArrayList<RpcJavaMethod> docJavaMethods = new ArrayList<RpcJavaMethod>();
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            for (JavaMethod method : parentMethodList) {
                docJavaMethods.add(this.convertToRpcJavaMethod(apiConfig, method, actualTypesMap));
            }
            docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, parentClass));
        }
        return docJavaMethods;
    }

    default public String replaceTypeName(String type, Map<String, JavaType> actualTypesMap, boolean simple) {
        if (Objects.isNull(actualTypesMap)) {
            return type;
        }
        for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
            if (!type.contains(entry.getKey())) continue;
            if (simple) {
                return type.replace(entry.getKey(), entry.getValue().getGenericValue());
            }
            return type.replace(entry.getKey(), entry.getValue().getGenericFullyQualifiedName());
        }
        return type;
    }
}

