/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.RpcJavaMethod;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.template.IRpcDocTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class RpcDocBuildTemplate
implements IDocBuildTemplate<RpcApiDoc>,
IRpcDocTemplate {
    private final AtomicInteger atomicInteger = new AtomicInteger(1);

    @Override
    public List<RpcApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        ArrayList<RpcApiDoc> apiDocList = new ArrayList<RpcApiDoc>();
        int order = 0;
        boolean setCustomOrder = false;
        for (JavaClass cls : projectBuilder.getJavaProjectBuilder().getClasses()) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls)) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.isEntryPoint(cls, null) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                order = Integer.parseInt(strOrder);
                setCustomOrder = true;
            }
            List<RpcJavaMethod> apiMethodDocs = this.buildServiceMethod(cls, apiConfig, projectBuilder);
            this.handleJavaApiDoc(cls, apiDocList, apiMethodDocs, order, projectBuilder);
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(RpcApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    private List<RpcJavaMethod> buildServiceMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        List methods = cls.getMethods();
        ArrayList<RpcJavaMethod> methodDocList = new ArrayList<RpcJavaMethod>(methods.size());
        Set<String> filterMethods = DocUtil.findFilterMethods(clazName);
        boolean needAllMethods = filterMethods.contains("*");
        for (Object method : methods) {
            if (method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"))) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            if (!needAllMethods && !filterMethods.contains(method.getName())) continue;
            RpcJavaMethod apiMethodDoc = this.convertToRpcJavaMethod(apiConfig, (JavaMethod)method, null);
            methodDocList.add(apiMethodDoc);
        }
        methodDocList.addAll(this.getParentsClassMethods(apiConfig, cls));
        if (cls.isInterface() || cls.isAbstract()) {
            List implClasses = cls.getImplements();
            for (JavaType type : implClasses) {
                JavaClass javaClass = (JavaClass)type;
                Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaClass);
                for (JavaMethod method : javaClass.getMethods()) {
                    if (method.isDefault()) continue;
                    methodDocList.add(this.convertToRpcJavaMethod(apiConfig, method, actualTypesMap));
                }
            }
        }
        int methodOrder = 0;
        ArrayList<RpcJavaMethod> rpcJavaMethods = new ArrayList<RpcJavaMethod>(methodDocList.size());
        for (RpcJavaMethod method : methodDocList) {
            method.setOrder(++methodOrder);
            String methodUid = DocUtil.generateId(clazName + method.getName() + methodOrder);
            method.setMethodId(methodUid);
            List<ApiParam> requestParams = this.requestParams(method.getJavaMethod(), projectBuilder, new AtomicInteger(0), method.getActualTypesMap());
            List<ApiParam> responseParams = this.buildReturnApiParams(DocJavaMethod.builder().setJavaMethod(method.getJavaMethod()).setActualTypesMap(method.getActualTypesMap()), projectBuilder);
            if (apiConfig.isParamsDataToTree()) {
                method.setRequestParams(ApiParamTreeUtil.apiParamToTree(requestParams));
                method.setResponseParams(ApiParamTreeUtil.apiParamToTree(responseParams));
            } else {
                method.setRequestParams(requestParams);
                method.setResponseParams(responseParams);
            }
            rpcJavaMethods.add(method);
        }
        return rpcJavaMethods;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, ProjectDocConfigBuilder builder, AtomicInteger atomicInteger, Map<String, JavaType> actualTypesMap) {
        boolean isStrict = builder.getApiConfig().isStrict();
        boolean isShowJavaType = builder.getApiConfig().getShowJavaType();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = DocUtil.getCommentsByTag(javaMethod, "param", className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return null;
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        for (JavaParameter parameter : parameterList) {
            ApiParam param;
            String[] gicNameArr;
            boolean required = false;
            String paramName = parameter.getName();
            String typeName = this.replaceTypeName(parameter.getType().getGenericCanonicalName(), actualTypesMap, Boolean.FALSE);
            String simpleName = this.replaceTypeName(parameter.getType().getValue(), actualTypesMap, Boolean.FALSE).toLowerCase();
            String fullTypeName = this.replaceTypeName(parameter.getType().getFullyQualifiedName(), actualTypesMap, Boolean.FALSE);
            String paramPre = paramName + ".";
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            String mockValue = JavaFieldUtil.createMockValue(paramTagMap, paramName, typeName, typeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            for (JavaAnnotation a : annotations) {
                if (!JavaClassValidateUtil.isJSR303Required(a.getType().getValue())) continue;
                required = true;
            }
            comment.append(JavaFieldUtil.getJsrComment(annotations));
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                String gicName;
                if (JavaClassValidateUtil.isCollection(typeName)) {
                    typeName = typeName + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName(typeName))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String processedType = isShowJavaType ? JavaClassUtil.getClassSimpleName(typeName) : DocClassUtil.processTypeNameForParams(simpleName);
                    ApiParam param2 = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setDesc(comment + "   (children type : " + gicName + ")").setRequired(required).setType(processedType);
                    paramList.add(param2);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                param = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType(JavaClassUtil.getClassSimpleName(typeName)).setDesc(comment.toString()).setRequired(required).setMaxLength(JavaFieldUtil.getParamMaxLength(parameter.getAnnotations())).setValue(mockValue).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType(typeName).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
                continue;
            }
            if (javaClass.isEnum()) {
                param = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType("Enum").setRequired(required).setDesc(comment.toString()).setVersion("-");
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
        }
        return paramList;
    }

    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if ("org.apache.dubbo.rpc.protocol.rest.integration.swagger.DubboSwaggerApiListingResource".equals(cls.getCanonicalName())) {
            return false;
        }
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getCanonicalName();
            if (!"org.apache.dubbo.config.annotation.Service".equals(name) && !"org.apache.dubbo.config.annotation.DubboService".equals(name) && !"com.alibaba.dubbo.config.annotation.Service".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubbo".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        return null;
    }

    private void handleJavaApiDoc(JavaClass cls, List<RpcApiDoc> apiDocList, List<RpcJavaMethod> apiMethodDocs, int order, ProjectDocConfigBuilder builder) {
        String className = cls.getCanonicalName();
        String shortName = cls.getName();
        String comment = cls.getComment();
        List javaTypes = cls.getImplements();
        if (javaTypes.size() >= 1 && !cls.isInterface()) {
            JavaType javaType = (JavaType)javaTypes.get(0);
            shortName = className = javaType.getCanonicalName();
            JavaClass javaClass = builder.getClassByName(className);
            if (StringUtil.isEmpty((String)comment) && Objects.nonNull(javaClass)) {
                comment = javaClass.getComment();
            }
        }
        RpcApiDoc apiDoc = new RpcApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(className);
        apiDoc.setShortName(shortName);
        apiDoc.setAlias(className);
        apiDoc.setUri(builder.getServerUrl() + "/" + className);
        apiDoc.setProtocol("dubbo");
        if (builder.getApiConfig().isMd5EncryptedHtmlName()) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        apiDoc.setDesc(DocUtil.getEscapeAndCleanComment(comment));
        apiDoc.setList(apiMethodDocs);
        List docletTags = cls.getTags();
        ArrayList<String> authorList = new ArrayList<String>();
        for (DocletTag docletTag : docletTags) {
            String name = docletTag.getName();
            if ("version".equals(name)) {
                apiDoc.setVersion(docletTag.getValue());
            }
            if (!"author".equals(name)) continue;
            authorList.add(docletTag.getValue());
        }
        apiDoc.setAuthor(String.join((CharSequence)", ", authorList));
        apiDocList.add(apiDoc);
    }
}

