/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.filter.ReturnTypeProcessor;
import com.power.doc.model.ApiReturn;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nonnull;

public class DocClassUtil {
    public static String[] getSimpleGicName(String typeName) {
        if (JavaClassValidateUtil.isCollection(typeName)) {
            typeName = typeName + "<T>";
        } else if (JavaClassValidateUtil.isArray(typeName)) {
            typeName = typeName.substring(0, typeName.lastIndexOf("["));
            typeName = "java.util.List<" + typeName + ">";
        } else if (JavaClassValidateUtil.isMap(typeName)) {
            typeName = typeName + "<String,T>";
        }
        if (typeName.contains("<")) {
            String pre = typeName.substring(0, typeName.indexOf("<"));
            if (JavaClassValidateUtil.isMap(pre)) {
                return DocClassUtil.getMapKeyValueType(typeName);
            }
            if (JavaClassValidateUtil.isCollection(pre)) {
                String type = typeName.substring(typeName.indexOf("<") + 1, typeName.lastIndexOf(">"));
                return type.split(" ");
            }
            String[] arr = (String[])Arrays.stream(DocClassUtil.getGicName(typeName)).map(str -> str.split(",")).map(Arrays::asList).flatMap(Collection::stream).toArray(String[]::new);
            return DocClassUtil.classNameFix(arr);
        }
        return new String[0];
    }

    static String[] getGicName(String typeName) {
        StringBuilder builder = new StringBuilder(typeName.length());
        ArrayList<String> ginNameList = new ArrayList<String>();
        int ltLen = 0;
        for (char c : typeName.toCharArray()) {
            if ((c == '<' || c == '>') && c == '<' && (ltLen += c == '<' ? 1 : -1) == 1) continue;
            if (ltLen > 0) {
                builder.append(c);
                continue;
            }
            if (ltLen != 0 || c != '>') continue;
            ginNameList.add(builder.toString());
            builder.setLength(0);
        }
        return ginNameList.toArray(new String[0]);
    }

    public static String getSimpleName(String gicName) {
        StringBuilder builder = new StringBuilder(gicName.length());
        int ltLen = 0;
        for (char c : gicName.toCharArray()) {
            if (c == '<' || c == '>') {
                ltLen += c == '<' ? 1 : -1;
                continue;
            }
            if (ltLen > 0) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static String[] classNameFix(String[] arr) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int globIndex = 0;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (classes.size() > 0) {
                int index = classes.size() - 1;
                if (!DocClassUtil.isClassName((String)classes.get(index))) {
                    if (++globIndex >= length) continue;
                    indexList.add(globIndex);
                    String className = (String)classes.get(index) + "," + arr[globIndex];
                    classes.set(index, className);
                    continue;
                }
                if (++globIndex >= length) continue;
                if (DocClassUtil.isClassName(arr[globIndex])) {
                    indexList.add(globIndex);
                    classes.add(arr[globIndex]);
                    continue;
                }
                if (indexList.contains(globIndex) || indexList.contains(globIndex + 1)) continue;
                indexList.add(globIndex);
                classes.add(arr[globIndex] + "," + arr[globIndex + 1]);
                indexList.add(++globIndex);
                continue;
            }
            if (DocClassUtil.isClassName(arr[i])) {
                indexList.add(i);
                classes.add(arr[i]);
                continue;
            }
            if (indexList.contains(i) || indexList.contains(i + 1)) continue;
            globIndex = i + 1;
            classes.add(arr[i] + "," + arr[globIndex]);
            indexList.add(i);
            indexList.add(i + 1);
        }
        return classes.toArray(new String[0]);
    }

    public static String[] getMapKeyValueType(String gName) {
        if (StringUtil.isEmpty((String)gName)) {
            return new String[0];
        }
        if (gName.contains("<")) {
            String[] arr = new String[2];
            String key = gName.substring(gName.indexOf("<") + 1, gName.indexOf(","));
            String value = gName.substring(gName.indexOf(",") + 1, gName.lastIndexOf(">"));
            arr[0] = key;
            arr[1] = value;
            return arr;
        }
        return new String[0];
    }

    public static String processTypeNameForParams(String javaTypeName) {
        if (StringUtil.isEmpty((String)javaTypeName)) {
            return "object";
        }
        if (javaTypeName.length() == 1) {
            return "object";
        }
        if (javaTypeName.contains("[]")) {
            return "array";
        }
        switch (javaTypeName = javaTypeName.toLowerCase()) {
            case "java.lang.string": 
            case "string": 
            case "char": 
            case "java.util.date": 
            case "date": 
            case "java.util.uuid": 
            case "uuid": 
            case "localdatetime": 
            case "java.time.localdatetime": 
            case "java.time.localdate": 
            case "java.time.localtime": 
            case "java.time.year": 
            case "java.time.yearmonth": 
            case "java.time.monthday": 
            case "java.time.period": 
            case "localdate": 
            case "offsetdatetime": 
            case "localtime": 
            case "timestamp": 
            case "zoneddatetime": 
            case "period": 
            case "java.time.zoneddatetime": 
            case "java.time.offsetdatetime": 
            case "java.sql.timestamp": 
            case "java.lang.character": 
            case "character": 
            case "org.bson.types.objectid": {
                return "string";
            }
            case "java.util.list": 
            case "list": 
            case "java.util.set": 
            case "set": 
            case "java.util.linkedlist": 
            case "linkedlist": 
            case "java.util.arraylist": 
            case "arraylist": 
            case "java.util.treeset": 
            case "treeset": {
                return "array";
            }
            case "java.lang.byte": 
            case "byte": {
                return "int8";
            }
            case "java.lang.integer": 
            case "integer": 
            case "int": {
                return "int32";
            }
            case "short": 
            case "java.lang.short": {
                return "int16";
            }
            case "double": 
            case "java.lang.double": {
                return "double";
            }
            case "java.lang.long": 
            case "long": {
                return "int64";
            }
            case "java.lang.float": 
            case "float": {
                return "float";
            }
            case "java.math.bigdecimal": 
            case "bigdecimal": 
            case "biginteger": {
                return "number";
            }
            case "java.lang.boolean": 
            case "boolean": {
                return "boolean";
            }
            case "map": {
                return "map";
            }
            case "multipartfile": {
                return "file";
            }
        }
        return "object";
    }

    public static ApiReturn processReturnType(String fullyName) {
        ReturnTypeProcessor processor = new ReturnTypeProcessor();
        processor.setTypeName(fullyName);
        return processor.process();
    }

    public static String rewriteRequestParam(String typeName) {
        switch (typeName) {
            case "org.springframework.data.domain.Pageable": {
                return "com.power.doc.model.framework.PageableAsQueryParam";
            }
        }
        return typeName;
    }

    private static boolean isClassName(String className) {
        className = className.replaceAll("[^<>]", "");
        Stack<Character> stack = new Stack<Character>();
        for (char c : className.toCharArray()) {
            if (c == '<') {
                stack.push(Character.valueOf('>'));
                continue;
            }
            if (!stack.isEmpty() && c == ((Character)stack.pop()).charValue()) continue;
            return false;
        }
        return stack.isEmpty();
    }

    public static List<JavaAnnotation> getAnnotations(JavaClass cls) {
        JavaClass superClass = cls.getSuperJavaClass();
        ArrayList<JavaAnnotation> classAnnotations = new ArrayList<JavaAnnotation>();
        try {
            if (Objects.nonNull(superClass)) {
                classAnnotations.addAll(superClass.getAnnotations());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not obtain annotations for class: " + cls.getFullyQualifiedName() + "\n" + e);
        }
        classAnnotations.addAll(cls.getAnnotations());
        return classAnnotations;
    }

    public static <T> T newInstance(@Nonnull Class<T> classWithNoArgsConstructor) {
        try {
            return classWithNoArgsConstructor.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Class must have the NoArgsConstructor");
        }
    }
}

