/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.building;

import java.util.Iterator;
import shiver.me.timbers.building.Block;
import shiver.me.timbers.building.Builder;

public abstract class IterableBuilder<T>
implements Builder<T> {
    private final T seed;
    private final Iterable<Block<T>> blocks;

    public IterableBuilder(Iterable<Block<T>> blocks, T seed) {
        this.blocks = blocks;
        this.seed = seed;
    }

    @Override
    public T build() {
        T finalResult = this.seed;
        for (T result : this) {
            finalResult = result;
        }
        return finalResult;
    }

    @Override
    public Iterable<T> iterable(final int iterations) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LimitedIterator(IterableBuilder.this, iterations);
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.seed);
    }

    Iterator<T> iterator(T seed) {
        return new ResultIterator<T>(this.blocks.iterator(), seed);
    }

    private static class LimitedIterator<T>
    implements Iterator<T> {
        private final IterableBuilder<T> builder;
        private final int iterations;
        private Iterator<T> iterator;
        private int count;
        private T result;

        public LimitedIterator(IterableBuilder<T> builder, int iterations) {
            this.builder = builder;
            this.iterations = iterations;
            this.iterator = builder.iterator();
        }

        @Override
        public boolean hasNext() {
            return !this.builder.isEmpty() && this.count < this.iterations;
        }

        @Override
        public T next() {
            T t;
            ++this.count;
            if (this.iterator.hasNext()) {
                this.result = this.iterator.next();
                t = this.result;
            } else {
                this.iterator = this.builder.iterator(this.result);
                this.result = this.iterator.next();
                t = this.result;
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ResultIterator<T>
    implements Iterator<T> {
        private final Iterator<Block<T>> iterator;
        private T result;

        public ResultIterator(Iterator<Block<T>> iterator, T result) {
            this.iterator = iterator;
            this.result = result;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.result = this.iterator.next().build(this.result);
            return this.result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

