/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.data.random;

import java.util.concurrent.ThreadLocalRandom;
import shiver.me.timbers.data.random.LoopGenerationStringsFactory;
import shiver.me.timbers.data.random.RandomCharacterGeneratorFactory;
import shiver.me.timbers.data.random.SomeStringsBuilder;
import shiver.me.timbers.data.random.StringsBuilder;

public class RandomStrings {
    private static StringsBuilder stringsBuilder() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new SomeStringsBuilder(random, new LoopGenerationStringsFactory(random, new RandomCharacterGeneratorFactory(random)));
    }

    public static String someString() {
        return RandomStrings.buildSomeString().build();
    }

    public static String someString(int length) {
        return RandomStrings.buildSomeString().withLength(length).build();
    }

    public static String someString(int min, int max) {
        return RandomStrings.stringsBuilder().withLengthBetween(min, max).build();
    }

    public static String someString(CharSequence characters) {
        return RandomStrings.buildSomeString().thatContains(characters).build();
    }

    public static String someString(int length, CharSequence characters) {
        return RandomStrings.buildSomeString().withLength(length).thatContains(characters).build();
    }

    public static String someString(int min, int max, CharSequence characters) {
        return RandomStrings.buildSomeString().withLengthBetween(min, max).thatContains(characters).build();
    }

    public static String someAlphaString() {
        return RandomStrings.buildSomeString().thatContainsAlphaCharacters().build();
    }

    public static String someAlphaString(int length) {
        return RandomStrings.buildSomeString().thatContainsAlphaCharacters().withLength(length).build();
    }

    public static String someAlphaString(int min, int max) {
        return RandomStrings.stringsBuilder().withLengthBetween(min, max).thatContainsAlphaCharacters().build();
    }

    public static String someNumericString() {
        return RandomStrings.buildSomeString().thatContainsNumericCharacters().build();
    }

    public static String someNumericString(int length) {
        return RandomStrings.buildSomeString().thatContainsNumericCharacters().withLength(length).build();
    }

    public static String someNumericString(int min, int max) {
        return RandomStrings.stringsBuilder().withLengthBetween(min, max).thatContainsNumericCharacters().build();
    }

    public static String someAlphanumericString() {
        return RandomStrings.buildSomeString().thatContainsAlphanumericCharacters().build();
    }

    public static String someAlphanumericString(int length) {
        return RandomStrings.buildSomeString().thatContainsAlphanumericCharacters().withLength(length).build();
    }

    public static String someAlphanumericString(int min, int max) {
        return RandomStrings.stringsBuilder().withLengthBetween(min, max).thatContainsAlphanumericCharacters().build();
    }

    public static StringsBuilder buildSomeString() {
        return RandomStrings.stringsBuilder();
    }
}

