/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.data.random;

import java.util.Random;
import shiver.me.timbers.data.random.Strings;
import shiver.me.timbers.data.random.StringsBuilder;
import shiver.me.timbers.data.random.StringsFactory;

class SomeStringsBuilder
implements StringsBuilder {
    private static final String ALPHAS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMERICS = "0123456789";
    private final Random random;
    private final StringsFactory stringsFactory;
    private final StringBuilder characters;
    private Integer lessThanLength;
    private Integer greaterThanLength;
    private Integer length;

    public SomeStringsBuilder(Random random, StringsFactory stringsFactory) {
        this.random = random;
        this.stringsFactory = stringsFactory;
        this.characters = new StringBuilder();
    }

    @Override
    public StringsBuilder withLengthBetween(int min, int max) {
        return this.withLengthGreaterThan(min).withLengthLessThan(max);
    }

    @Override
    public StringsBuilder withLengthLessThan(int length) {
        this.lessThanLength = length;
        return this;
    }

    @Override
    public StringsBuilder withLengthGreaterThan(int length) {
        this.greaterThanLength = length;
        return this;
    }

    @Override
    public StringsBuilder withLength(int length) {
        this.length = length;
        return this;
    }

    @Override
    public StringsBuilder thatContainsAlphanumericCharacters() {
        return this.thatContainsAlphaCharacters().thatContainsNumericCharacters();
    }

    @Override
    public StringsBuilder thatContainsAlphaCharacters() {
        return this.thatContains(ALPHAS);
    }

    @Override
    public StringsBuilder thatContainsNumericCharacters() {
        return this.thatContains(NUMERICS);
    }

    @Override
    public StringsBuilder thatContains(CharSequence characters) {
        this.characters.append(characters);
        return this;
    }

    @Override
    public String build() {
        Strings strings = this.strings();
        Integer length = this.length();
        if (length != null) {
            return strings.someString(length);
        }
        return strings.someString();
    }

    @Override
    public String toString() {
        return this.build();
    }

    private Strings strings() {
        if (this.characters.length() > 0) {
            return this.stringsFactory.strings(this.characters);
        }
        return this.stringsFactory.strings();
    }

    private Integer length() {
        if (this.length != null) {
            return this.length;
        }
        if (this.lessThanLength != null && this.greaterThanLength != null) {
            return this.rangeLength();
        }
        if (this.lessThanLength != null) {
            return this.lessThanLength();
        }
        if (this.greaterThanLength != null) {
            return this.greaterThanLength();
        }
        return null;
    }

    private Integer rangeLength() {
        if (this.lessThanLength < this.greaterThanLength) {
            throw new IllegalStateException(String.format("Cannot generate a string with a length greater than: %d and less than: %d", this.greaterThanLength, this.lessThanLength));
        }
        int increment = this.random.nextInt(this.lessThanLength - this.greaterThanLength + 1);
        return this.greaterThanLength + increment;
    }

    private Integer lessThanLength() {
        return this.random.nextInt(this.lessThanLength + 1);
    }

    private Integer greaterThanLength() {
        return this.greaterThanLength + this.random.nextInt(1025);
    }
}

