/*
 * Decompiled with CFR 0.152.
 */
package com.github.shnewto.bqjson;

import com.github.shnewto.bqjson.surrogate.SFieldList;
import com.github.shnewto.bqjson.surrogate.SSchema;
import com.github.shnewto.bqjson.surrogate.STableResult;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableResult;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerDe {
    private static final Logger log = LoggerFactory.getLogger(SerDe.class);

    public static String toJson(TableResult tableResult) {
        Gson gson = new Gson();
        return gson.toJson((Object)new STableResult(tableResult));
    }

    public static byte[] toJsonBytes(TableResult tableResult) {
        Gson gson = new Gson();
        return gson.toJson((Object)new STableResult(tableResult)).getBytes(StandardCharsets.UTF_8);
    }

    public static String toJson(Schema schema) {
        Gson gson = new Gson();
        return gson.toJson((Object)new SSchema(schema));
    }

    public static byte[] toJsonBytes(Schema schema) {
        Gson gson = new Gson();
        return gson.toJson((Object)new SSchema(schema)).getBytes(StandardCharsets.UTF_8);
    }

    public static String toJson(FieldList fieldList) {
        Gson gson = new Gson();
        return gson.toJson((Object)new SFieldList((List<Field>)fieldList));
    }

    public static byte[] toJsonBytes(FieldList fieldList) {
        Gson gson = new Gson();
        return gson.toJson((Object)new SFieldList((List<Field>)fieldList)).getBytes(StandardCharsets.UTF_8);
    }

    public static <T> T fromJson(String object, Class<T> classOfT) throws ClassCastException {
        try {
            if (classOfT == TableResult.class) {
                return classOfT.cast(SerDe.tableResultFromJson(object));
            }
            if (classOfT == Schema.class) {
                return classOfT.cast(SerDe.schemaFromJson(object));
            }
            if (classOfT == FieldList.class) {
                return classOfT.cast(SerDe.fieldListFromJson(object));
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return null;
    }

    public static <T> T fromJson(byte[] bytes, Class<T> classOfT) {
        return SerDe.fromJson(new String(bytes, StandardCharsets.UTF_8), classOfT);
    }

    private static TableResult tableResultFromJson(String tableResultJson) {
        Gson gson = new Gson();
        return ((STableResult)gson.fromJson(tableResultJson, STableResult.class)).toTableResult();
    }

    private static Schema schemaFromJson(String schemaJson) {
        Gson gson = new Gson();
        return ((SSchema)gson.fromJson(schemaJson, SSchema.class)).toSchema();
    }

    private static FieldList fieldListFromJson(String fieldListJson) {
        Gson gson = new Gson();
        return ((SFieldList)gson.fromJson(fieldListJson, SFieldList.class)).toFieldList();
    }
}

