/*
 * Decompiled with CFR 0.152.
 */
package com.github.shnewto.bqjson.surrogate;

import com.github.shnewto.bqjson.surrogate.SSchema;
import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class STableResult {
    final SSchema schema;
    final long totalRows;
    List<FieldValueList> fieldValueLists;

    public STableResult(TableResult tableResult) {
        this.schema = new SSchema(tableResult.getSchema());
        this.totalRows = tableResult.getTotalRows();
        this.fieldValueLists = new ArrayList<FieldValueList>();
        this.pageNoSchema(tableResult);
    }

    private void sanitizeFieldValueLists() {
        ArrayList<FieldValueList> sanitized = new ArrayList<FieldValueList>();
        for (List list : this.fieldValueLists) {
            sanitized.add(FieldValueList.of((List)list, (FieldList)this.schema.getFields()));
        }
        this.fieldValueLists = sanitized;
    }

    private void pageNoSchema(TableResult tableResult) {
        tableResult.iterateAll().iterator().forEachRemaining(this.fieldValueLists::add);
    }

    private Page<FieldValueList> pageNoSchema() {
        return new PageImpl((PageImpl.NextPageFetcher & Serializable)() -> null, null, this.fieldValueLists);
    }

    public TableResult toTableResult() {
        this.sanitizeFieldValueLists();
        return new TableResult(this.schema.toSchema(), this.totalRows, this.pageNoSchema());
    }
}

