/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.reporter.json;

import com.github.shyiko.ktlint.core.LintError;
import com.github.shyiko.ktlint.core.Reporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/github/shyiko/ktlint/reporter/json/JsonReporter;", "Lcom/github/shyiko/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/github/shyiko/ktlint/core/LintError;", "getOut", "()Ljava/io/PrintStream;", "afterAll", "", "onLintError", "file", "err", "corrected", "", "escapeJsonValue", "ktlint-reporter-json"})
public final class JsonReporter
implements Reporter {
    private final ConcurrentHashMap<String, List<LintError>> acc;
    @NotNull
    private final PrintStream out;

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
        if (!corrected) {
            ConcurrentMap $receiver$iv = this.acc;
            Object object = $receiver$iv.get(file);
            if (object == null) {
                boolean bl = false;
                ArrayList arrayList = new ArrayList();
                ArrayList default$iv = arrayList;
                object = $receiver$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(err);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void afterAll() {
        this.out.println("[");
        int indexLast = this.acc.size() - 1;
        boolean bl = false;
        Set<Map.Entry<String, List<LintError>>> set = this.acc.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"acc.entries");
        Object $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (Map.Entry entry : (Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object)) {
            void index;
            void file;
            Object $i$f$sortedBy22 = object = entry;
            $receiver$iv = (String)$i$f$sortedBy22.getKey();
            $i$f$sortedBy22 = object;
            List errList = (List)$i$f$sortedBy22.getValue();
            this.out.println("\t{");
            StringBuilder stringBuilder = new StringBuilder().append("\t\t\"file\": \"");
            void v2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file");
            this.out.println(stringBuilder.append(this.escapeJsonValue((String)v2)).append("\",").toString());
            this.out.println("\t\t\"errors\": [");
            int errIndexLast = errList.size() - 1;
            boolean $i$f$sortedBy22 = false;
            List list = errList;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"errList");
            Iterator iterator = ((Iterable)list).iterator();
            while (iterator.hasNext()) {
                void errIndex;
                void ruleId;
                void col;
                void line;
                LintError err;
                LintError lintError = err = (LintError)iterator.next();
                int n = lintError.component1();
                int n2 = lintError.component2();
                String string = lintError.component3();
                String detail = lintError.component4();
                this.out.println("\t\t\t{");
                this.out.println("\t\t\t\t\"line\": " + (int)line + ',');
                this.out.println("\t\t\t\t\"column\": " + (int)col + ',');
                this.out.println("\t\t\t\t\"message\": \"" + this.escapeJsonValue(detail) + "\",");
                this.out.println("\t\t\t\t\"rule\": \"" + (String)ruleId + '\"');
                this.out.println("\t\t\t}" + (errIndex != errIndexLast ? "," : ""));
                ++errIndex;
            }
            this.out.println("\t\t]");
            this.out.println("\t}" + (index != indexLast ? "," : ""));
            ++index;
        }
        this.out.println("]");
    }

    private final String escapeJsonValue(@NotNull String $receiver) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\b", (String)"\\b", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public JsonReporter(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    public void after(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.after((Reporter)this, (String)file);
    }

    public void before(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

