/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\f\u0010\u0017\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\r*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/ChainWrappingRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isInPrefixPosition", "isPartOfSpread", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isPartOfWhenCondition", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends Rule {
    private final TokenSet sameLineTokens;
    private final TokenSet prefixTokens;
    private final TokenSet nextLineTokens;
    private final TokenSet noSpaceAroundTokens;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        if (this.nextLineTokens.contains(elementType)) {
            PsiElement nextLeaf;
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
            if (PackageKt.isPartOf(psiElement, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                return;
            }
            PsiElement psiElement2 = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"node.psi");
            PsiElement psiElement3 = PackageKt.nextLeafIgnoringWhitespaceAndComments(psiElement2);
            Object object = nextLeaf = psiElement3 != null ? PsiUtilsKt.prevLeaf((PsiElement)psiElement3, (boolean)true) : null;
            if (nextLeaf instanceof PsiWhiteSpaceImpl && nextLeaf.textContains('\n')) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    PsiElement psiElement4 = node.getPsi();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"node.psi");
                    PsiElement prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)psiElement4, (boolean)true);
                    if (prevLeaf instanceof PsiWhiteSpaceImpl) {
                        ASTNode aSTNode = ((PsiWhiteSpaceImpl)prevLeaf).getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"prevLeaf.node");
                        aSTNode.getTreeParent().removeChild(((PsiWhiteSpaceImpl)prevLeaf).getNode());
                    }
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        ((PsiWhiteSpaceImpl)nextLeaf).rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                    }
                    node.getTreeParent().removeChild(node);
                    PsiElement psiElement5 = node.getPsi();
                    if (psiElement5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((PsiWhiteSpaceImpl)nextLeaf).rawInsertAfterMe((TreeElement)((LeafPsiElement)psiElement5));
                }
            }
        } else if (this.sameLineTokens.contains(elementType) || this.prefixTokens.contains(elementType)) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
            if (PackageKt.isPartOf(psiElement, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                return;
            }
            PsiElement psiElement6 = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"node.psi");
            PsiElement prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)psiElement6, (boolean)true);
            if (!(!(prevLeaf instanceof PsiWhiteSpaceImpl) || !prevLeaf.textContains('\n') || !(Intrinsics.areEqual((Object)elementType, (Object)KtTokens.MUL) ^ true) && this.isPartOfSpread(prevLeaf) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node) || this.isPartOfWhenCondition(node))) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    PsiElement psiElement7 = node.getPsi();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement7, (String)"node.psi");
                    PsiElement nextLeaf = PsiUtilsKt.nextLeaf((PsiElement)psiElement7, (boolean)true);
                    if (nextLeaf instanceof PsiWhiteSpaceImpl) {
                        ASTNode aSTNode = ((PsiWhiteSpaceImpl)nextLeaf).getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"nextLeaf.node");
                        aSTNode.getTreeParent().removeChild(((PsiWhiteSpaceImpl)nextLeaf).getNode());
                    }
                    PsiElement psiElement8 = PackageKt.prevLeafIgnoringWhitespaceAndComments(prevLeaf);
                    if (psiElement8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement insertionPoint = (LeafPsiElement)psiElement8;
                    node.getTreeParent().removeChild(node);
                    PsiElement psiElement9 = node.getPsi();
                    if (psiElement9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    insertionPoint.rawInsertAfterMe((TreeElement)((LeafPsiElement)psiElement9));
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        insertionPoint.rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfSpread(@NotNull PsiElement $receiver) {
        PsiElement psiElement;
        PsiElement psiElement2 = PackageKt.prevLeafIgnoringWhitespaceAndComments($receiver);
        if (psiElement2 == null) return false;
        PsiElement leaf = psiElement = psiElement2;
        boolean bl = false;
        ASTNode aSTNode = leaf.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"leaf.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"leaf.node.elementType");
        IElementType type = iElementType;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.LPAR)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.COMMA)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.LBRACE)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.ELSE_KEYWORD)) return true;
        if (!KtTokens.OPERATIONS.contains(type)) return false;
        return true;
    }

    private final boolean isInPrefixPosition(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.PREFIX_EXPRESSION);
    }

    private final boolean isPartOfWhenCondition(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreeParent();
        return Intrinsics.areEqual(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null, (Object)KtNodeTypes.WHEN_CONDITION_EXPRESSION);
    }

    public ChainWrappingRule() {
        super("chain-wrapping");
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.MUL, (IElementType)KtTokens.DIV, (IElementType)KtTokens.PERC, (IElementType)KtTokens.ANDAND, (IElementType)KtTokens.OROR});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(MUL, DIV, PERC, ANDAND, OROR)");
        this.sameLineTokens = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.PLUS, (IElementType)KtTokens.MINUS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(PLUS, MINUS)");
        this.prefixTokens = tokenSet2;
        TokenSet tokenSet3 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.DOT, (IElementType)KtTokens.SAFE_ACCESS, (IElementType)KtTokens.ELVIS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"TokenSet.create(DOT, SAFE_ACCESS, ELVIS)");
        this.nextLineTokens = tokenSet3;
        TokenSet tokenSet4 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.DOT, (IElementType)KtTokens.SAFE_ACCESS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet4, (String)"TokenSet.create(DOT, SAFE_ACCESS)");
        this.noSpaceAroundTokens = tokenSet4;
    }
}

