/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.EditorConfig;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\u0010Je\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\b0\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/FinalNewlineRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "Lcom/github/shyiko/ktlint/core/Rule$Modifier$RestrictToRoot;", "()V", "lastChildNodeOf", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "node", "visit", "", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class FinalNewlineRule
extends Rule
implements Rule.Modifier.RestrictToRoot {
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            EditorConfig ec = EditorConfig.Companion.from((FileASTNode)node);
            Boolean bl = ec.getInsertFinalNewline();
            if (bl == null) {
                return;
            }
            boolean insertFinalNewline = bl;
            ASTNode lastNode = this.lastChildNodeOf(node);
            if (insertFinalNewline) {
                if (!(lastNode instanceof PsiWhiteSpace) || !lastNode.textContains('\n')) {
                    emit.invoke((Object)0, (Object)"File must end with a newline (\\n)", (Object)true);
                    if (autoCorrect) {
                        node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                    }
                }
            } else if (lastNode instanceof PsiWhiteSpace && lastNode.textContains('\n')) {
                emit.invoke((Object)lastNode.getStartOffset(), (Object)"Redundant newline (\\n) at the end of file", (Object)true);
                if (autoCorrect) {
                    ASTNode aSTNode = ((PsiWhiteSpace)lastNode).getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"lastNode.node");
                    aSTNode.getTreeParent().removeChild(((PsiWhiteSpace)lastNode).getNode());
                }
            }
        }
    }

    private final ASTNode lastChildNodeOf(ASTNode node) {
        while (node.getLastChildNode() != null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)node.getLastChildNode(), (String)"node.lastChildNode");
        }
        return node;
    }

    public FinalNewlineRule() {
        super("final-newline");
    }
}

