/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.EditorConfig;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/IndentationRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "indentSize", "", "gcd", "a", "b", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "previousIndentSize", "ktlint-ruleset-standard"})
public final class IndentationRule
extends Rule {
    private int indentSize = -1;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            EditorConfig ec = EditorConfig.Companion.from((FileASTNode)node);
            int n = ec.getIndentSize();
            int n2 = 1;
            IndentationRule indentationRule = this;
            IndentationRule indentationRule2 = this;
            int n3 = Math.max(n, n2);
            n = ec.getContinuationIndentSize();
            n2 = 1;
            int n4 = Math.max(n, n2);
            indentationRule2.indentSize = indentationRule.gcd(n3, n4);
            return;
        }
        if (this.indentSize <= 1) {
            return;
        }
        if (node instanceof PsiWhiteSpace && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.getText()");
            List lines = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            if (lines.size() > 1 && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtTypeConstraintList.class))) {
                int offset = node.getStartOffset() + ((String)CollectionsKt.first((List)lines)).length() + 1;
                int previousIndentSize = this.previousIndentSize(node);
                Iterable $receiver$iv = PackageKt.tail(lines);
                for (Object element$iv : $receiver$iv) {
                    String indent = (String)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = indent;
                    if (charSequence.length() > 0 && (indent.length() - previousIndentSize) % this.indentSize != 0 && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtParameterList.class))) {
                        emit.invoke((Object)offset, (Object)("Unexpected indentation (" + indent.length() + ") (it should be " + (previousIndentSize + this.indentSize) + ')'), (Object)false);
                    }
                    offset += indent.length() + 1;
                }
            }
            if (node.textContains('\t')) {
                String string2 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.getText()");
                String text = string2;
                emit.invoke((Object)(node.getStartOffset() + StringsKt.indexOf$default((CharSequence)text, (char)'\t', (int)0, (boolean)false, (int)6, null)), (Object)"Unexpected Tab character(s)", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawReplaceWithText(StringsKt.replace$default((String)text, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)this.indentSize), (boolean)false, (int)4, null));
                }
            }
        }
    }

    private final int gcd(int a, int b) {
        return a > b ? this.gcd(a - b, b) : (a < b ? this.gcd(a, b - a) : a);
    }

    private final int previousIndentSize(@NotNull ASTNode $receiver) {
        PsiElement node;
        ASTNode aSTNode = $receiver.getTreeParent();
        Object object = node = aSTNode != null ? aSTNode.getPsi() : null;
        while (node != null) {
            PsiElement psiElement;
            IElementType nextNode;
            PsiElement psiElement2 = node.getNextSibling();
            IElementType iElementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : (nextNode = null);
            if (node instanceof PsiWhiteSpace && Intrinsics.areEqual((Object)nextNode, (Object)KtStubElementTypes.TYPE_REFERENCE) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)KtStubElementTypes.SUPER_TYPE_LIST) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL) ^ true && node.textContains('\n')) {
                PsiElement psiElement3 = PackageKt.nextLeaf(node);
                if (psiElement3 == null || !PackageKt.isPartOf(psiElement3, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    int n = ((PsiWhiteSpace)node).getText().length();
                    String string = ((PsiWhiteSpace)node).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
                    return n - StringsKt.lastIndexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
            }
            if ((psiElement = node.getPrevSibling()) == null) {
                psiElement = node.getParent();
            }
            node = psiElement;
        }
        return 0;
    }

    public IndentationRule() {
        super("indent");
    }
}

