/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.EditorConfig;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import com.github.shyiko.ktlint.ruleset.standard.RangeTree;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\t0\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/MaxLineLengthRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "Lcom/github/shyiko/ktlint/core/Rule$Modifier$Last;", "()V", "maxLineLength", "", "rangeTree", "Lcom/github/shyiko/ktlint/ruleset/standard/RangeTree;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class MaxLineLengthRule
extends Rule
implements Rule.Modifier.Last {
    private int maxLineLength = -1;
    private RangeTree rangeTree = new RangeTree(null, 1, null);

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            EditorConfig ec = EditorConfig.Companion.from((FileASTNode)node);
            this.maxLineLength = ec.getMaxLineLength();
            if (this.maxLineLength <= 0) {
                return;
            }
            ArrayList<Integer> errorOffset = new ArrayList<Integer>();
            String string = ((FileASTNode)node).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
            String text = string;
            List lines = StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            int offset = 0;
            for (String line : lines) {
                if (line.length() > this.maxLineLength) {
                    PsiElement el;
                    if (((FileASTNode)node).getPsi().findElementAt(offset + line.length() - 1) == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)el, (String)"node.psi.findElementAt(offset + line.length - 1)!!");
                    if (!PackageKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KDoc.class)) && !PackageKt.isPartOfMultiLineString(el)) {
                        if (!PackageKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                            if (!PackageKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtPackageDirective.class)) && !PackageKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) {
                                errorOffset.add(offset);
                            }
                        } else {
                            PsiElement prevLeaf = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)el, (boolean)false);
                            if (prevLeaf != null && PsiUtilsKt.getStartOffset((PsiElement)prevLeaf) >= offset) {
                                errorOffset.add(offset);
                            }
                        }
                    }
                }
                offset += line.length() + 1;
            }
            this.rangeTree = new RangeTree((List<Integer>)errorOffset);
        } else if (!this.rangeTree.isEmpty() && node.getPsi() instanceof LeafPsiElement) {
            RangeTree.ArrayView this_$iv = this.rangeTree.query(node.getStartOffset(), node.getStartOffset() + node.getTextLength());
            boolean $i$f$forEach = false;
            int i$iv = 0;
            while (i$iv < this_$iv.getSize()) {
                int offset = this_$iv.get(i$iv++);
                boolean bl = false;
                emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
            }
        }
    }

    public MaxLineLengthRule() {
        super("max-line-length");
    }
}

