/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004H\u0002\u00a2\u0006\u0002\u0010\u000fJe\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142K\u0010\u0015\u001aG\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00110\u0016H\u0016R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/ModifierOrderRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "order", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "tokenSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "squashAnnotations", "", "", "sorted", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Ljava/util/List;", "visit", "", "node", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class ModifierOrderRule
extends Rule {
    private final IElementType[] order = new IElementType[]{(IElementType)KtStubElementTypes.ANNOTATION_ENTRY, (IElementType)KtTokens.PUBLIC_KEYWORD, (IElementType)KtTokens.PROTECTED_KEYWORD, (IElementType)KtTokens.PRIVATE_KEYWORD, (IElementType)KtTokens.INTERNAL_KEYWORD, (IElementType)KtTokens.EXPECT_KEYWORD, (IElementType)KtTokens.ACTUAL_KEYWORD, (IElementType)KtTokens.FINAL_KEYWORD, (IElementType)KtTokens.OPEN_KEYWORD, (IElementType)KtTokens.ABSTRACT_KEYWORD, (IElementType)KtTokens.SEALED_KEYWORD, (IElementType)KtTokens.CONST_KEYWORD, (IElementType)KtTokens.EXTERNAL_KEYWORD, (IElementType)KtTokens.OVERRIDE_KEYWORD, (IElementType)KtTokens.LATEINIT_KEYWORD, (IElementType)KtTokens.TAILREC_KEYWORD, (IElementType)KtTokens.VARARG_KEYWORD, (IElementType)KtTokens.SUSPEND_KEYWORD, (IElementType)KtTokens.INNER_KEYWORD, (IElementType)KtTokens.ENUM_KEYWORD, (IElementType)KtTokens.ANNOTATION_KEYWORD, (IElementType)KtTokens.COMPANION_KEYWORD, (IElementType)KtTokens.INLINE_KEYWORD, (IElementType)KtTokens.INFIX_KEYWORD, (IElementType)KtTokens.OPERATOR_KEYWORD, (IElementType)KtTokens.DATA_KEYWORD};
    private final TokenSet tokenSet;

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (node.getPsi() instanceof KtDeclarationModifierList) {
            Object[] modifierArr;
            Object[] objectArray = node.getChildren(this.tokenSet);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.getChildren(tokenSet)");
            Object[] objectArray2 = modifierArr = objectArray;
            ASTNode[] aSTNodeArray = Arrays.copyOf(objectArray2, objectArray2.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"java.util.Arrays.copyOf(this, size)");
            Object[] $receiver = objectArray2 = aSTNodeArray;
            boolean bl = false;
            Object[] objectArray3 = $receiver;
            Comparator comparator = new Comparator<T>(this){
                final /* synthetic */ ModifierOrderRule this$0;
                {
                    this.this$0 = modifierOrderRule;
                }

                public final int compare(T a, T b) {
                    ASTNode it = (ASTNode)a;
                    boolean bl = false;
                    Object[] objectArray = ModifierOrderRule.access$getOrder$p(this.this$0);
                    ASTNode aSTNode = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                    it = (ASTNode)b;
                    Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])objectArray, (Object)aSTNode.getElementType()));
                    bl = false;
                    Object[] objectArray2 = ModifierOrderRule.access$getOrder$p(this.this$0);
                    ASTNode aSTNode2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"it");
                    Integer n = ArraysKt.indexOf((Object[])objectArray2, (Object)aSTNode2.getElementType());
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            ArraysKt.sortWith((Object[])objectArray3, (Comparator)comparator);
            Object[] sorted = (ASTNode[])objectArray2;
            if (!Arrays.equals(modifierArr, sorted)) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Incorrect modifier order (should be \"" + CollectionsKt.joinToString$default((Iterable)this.squashAnnotations((ASTNode[])sorted), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\")"), (Object)true);
                if (autoCorrect) {
                    Object[] $receiver$iv = modifierArr;
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv) {
                        void n;
                        int n2 = index$iv++;
                        Object object = item$iv;
                        int i = n2;
                        boolean bl2 = false;
                        Object object2 = sorted[i].clone();
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.lang.ASTNode");
                        }
                        node.replaceChild((ASTNode)n, (ASTNode)object2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> squashAnnotations(ASTNode[] sorted) {
        List list;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        ASTNode[] aSTNodeArray = $receiver$iv = sorted;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            if (!(!(it.getPsi() instanceof KtAnnotationEntry))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonAnnotationModifiers = (List)destination$iv$iv;
        if (nonAnnotationModifiers.size() != sorted.length) {
            Collection<String> collection;
            $receiver$iv = nonAnnotationModifiers;
            Collection collection2 = CollectionsKt.listOf((Object)"@Annotation...");
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getText();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        } else {
            $receiver$iv = nonAnnotationModifiers;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                ASTNode it = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getText();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public ModifierOrderRule() {
        super("modifier-order");
        TokenSet tokenSet = TokenSet.create((IElementType[])Arrays.copyOf(this.order, this.order.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(*order)");
        this.tokenSet = tokenSet;
    }

    public static final /* synthetic */ IElementType[] access$getOrder$p(ModifierOrderRule $this) {
        return $this.order;
    }
}

