/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/NoEmptyClassBodyRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class NoEmptyClassBodyRule
extends Rule {
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.CLASS_BODY)) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
            if (psiElement.getFirstChild() != null) {
                PsiElement psiElement2 = node.getPsi();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"node.psi");
                PsiElement psiElement3 = psiElement2.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"node.psi.firstChild");
                ASTNode aSTNode = psiElement3.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.psi.firstChild.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.LBRACE)) {
                    PsiElement psiElement4 = node.getPsi();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"node.psi");
                    PsiElement psiElement5 = psiElement4.getFirstChild();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"node.psi.firstChild");
                    PsiElement psiElement6 = PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)psiElement5, (boolean)false);
                    if (psiElement6 == null) {
                        Intrinsics.throwNpe();
                    }
                    ASTNode aSTNode2 = psiElement6.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.psi.firstChild.getN\u2026gWhitespace(false)!!.node");
                    if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)KtTokens.RBRACE)) {
                        PsiElement psiElement7 = node.getPsi();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement7, (String)"node.psi");
                        if (!PackageKt.isPartOf(psiElement7, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtObjectLiteralExpression.class))) {
                            emit.invoke((Object)node.getStartOffset(), (Object)"Unnecessary block (\"{}\")", (Object)true);
                            if (autoCorrect) {
                                PsiElement psiElement8 = node.getPsi();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement8, (String)"node.psi");
                                PsiElement psiElement9 = psiElement8.getPrevSibling();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement9, (String)"node.psi.prevSibling");
                                ASTNode prevNode = psiElement9.getNode();
                                PsiElement psiElement10 = PsiTreeUtil.nextLeaf((PsiElement)node.getPsi(), (boolean)true);
                                ASTNode nextNode = psiElement10 != null ? psiElement10.getNode() : null;
                                ASTNode aSTNode3 = prevNode;
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"prevNode");
                                if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)KtTokens.WHITE_SPACE) && (nextNode == null || Intrinsics.areEqual((Object)nextNode.getElementType(), (Object)KtTokens.WHITE_SPACE))) {
                                    prevNode.getTreeParent().removeChild(prevNode);
                                }
                                if (nextNode != null && Intrinsics.areEqual((Object)nextNode.getElementType(), (Object)KtTokens.WHITE_SPACE) ^ true) {
                                    ((TreeElement)node).rawInsertBeforeMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                                }
                                node.getTreeParent().removeChild(node);
                            }
                        }
                    }
                }
            }
        }
    }

    public NoEmptyClassBodyRule() {
        super("no-empty-class-body");
    }
}

