/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtEnumEntry;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002Je\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/NoSemicolonsRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "doesNotRequirePreSemi", "", "nextLeaf", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class NoSemicolonsRule
extends Rule {
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (node instanceof LeafPsiElement && ((LeafPsiElement)node).textMatches((CharSequence)";") && !PackageKt.isPartOfString((PsiElement)node) && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtEnumEntry.class))) {
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)node), (boolean)true);
            if (this.doesNotRequirePreSemi(nextLeaf)) {
                PsiElement psiElement = ((LeafPsiElement)node).getPsi();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
                PsiElement psiElement2 = PackageKt.prevLeafIgnoringWhitespaceAndComments(psiElement);
                if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.OBJECT_KEYWORD)) {
                    return;
                }
                emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)"Unnecessary semicolon", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).getTreeParent().removeChild(node);
                }
            } else if (!(nextLeaf instanceof PsiWhiteSpace)) {
                PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)((PsiElement)node), (boolean)true);
                if (prevLeaf instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                    return;
                }
                emit.invoke((Object)(((LeafPsiElement)node).getStartOffset() + 1), (Object)"Missing spacing after \";\"", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                }
            }
        }
    }

    private final boolean doesNotRequirePreSemi(PsiElement nextLeaf) {
        if (nextLeaf instanceof PsiWhiteSpace) {
            PsiElement nextNextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf, (boolean)true);
            return nextNextLeaf == null || nextLeaf.textContains('\n') && !nextNextLeaf.textMatches((CharSequence)"{");
        }
        return nextLeaf == null;
    }

    public NoSemicolonsRule() {
        super("no-semi");
    }
}

