/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\f0\u0012H\u0016J\f\u0010\u0019\u001a\u00020\u0010*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/NoUnusedImportsRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "componentNRegex", "Lkotlin/text/Regex;", "operatorSet", "", "", "packageName", "ref", "", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "isComponentN", "ktlint-ruleset-standard"})
public final class NoUnusedImportsRule
extends Rule {
    private final Regex componentNRegex = new Regex("^component\\d+$");
    private final Set<String> operatorSet = SetsKt.setOf((Object[])new String[]{"unaryPlus", "unaryMinus", "not", "inc", "dec", "plus", "minus", "times", "div", "rem", "mod", "rangeTo", "contains", "get", "set", "invoke", "plusAssign", "minusAssign", "timesAssign", "divAssign", "modAssign", "equals", "compareTo", "iterator", "getValue", "setValue"});
    private final Set<String> ref;
    private String packageName;

    /*
     * Enabled aggressive block sorting
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            this.ref.clear();
            this.ref.add("*");
            PackageKt.visit(node, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>(this){
                final /* synthetic */ NoUnusedImportsRule this$0;

                public final void invoke(@NotNull ASTNode vnode) {
                    Intrinsics.checkParameterIsNotNull((Object)vnode, (String)"vnode");
                    PsiElement psi = vnode.getPsi();
                    IElementType iElementType = vnode.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"vnode.elementType");
                    IElementType type = iElementType;
                    if (Intrinsics.areEqual((Object)type, (Object)KDocTokens.MARKDOWN_LINK) && psi instanceof KDocLink) {
                        String linkText = StringsKt.replace$default((String)((KDocLink)psi).getLinkText(), (String)"`", (String)"", (boolean)false, (int)4, null);
                        NoUnusedImportsRule.access$getRef$p(this.this$0).add(CollectionsKt.first((List)StringsKt.split$default((CharSequence)linkText, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)));
                    } else if (Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.REFERENCE_EXPRESSION) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.OPERATION_REFERENCE)) {
                        PsiElement psiElement = psi;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"psi");
                        if (!PackageKt.isPartOf(psiElement, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) {
                            Set set = NoUnusedImportsRule.access$getRef$p(this.this$0);
                            String string = vnode.getText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"vnode.text");
                            set.add(StringsKt.trim((String)string, (char[])new char[]{'`'}));
                        }
                    }
                }
                {
                    this.this$0 = noUnusedImportsRule;
                    super(1);
                }
            }));
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.PACKAGE_DIRECTIVE)) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPackageDirective");
            }
            KtPackageDirective packageDirective = (KtPackageDirective)psiElement;
            String string = packageDirective.getQualifiedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageDirective.qualifiedName");
            this.packageName = string;
            return;
        }
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.IMPORT_DIRECTIVE)) return;
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
        }
        KtImportDirective importDirective = (KtImportDirective)psiElement;
        ImportPath importPath = importDirective.getImportPath();
        String name = importPath != null && (importPath = importPath.getImportedName()) != null ? importPath.asString() : null;
        ImportPath importPath2 = importDirective.getImportPath();
        String string = importPath2 != null ? importPath2.getPathStr() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String importPath3 = string;
        if (importDirective.getAliasName() == null && ((charSequence = (CharSequence)this.packageName).length() == 0 || StringsKt.startsWith$default((String)importPath3, (String)(this.packageName + '.'), (boolean)false, (int)2, null))) {
            charSequence = importPath3;
            int n = this.packageName.length() + 1;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)charSequence2).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            if (StringsKt.indexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                emit.invoke((Object)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)importDirective)), (Object)"Unnecessary import", (Object)true);
                if (!autoCorrect) return;
                importDirective.delete();
                return;
            }
        }
        if (name == null) return;
        if (this.ref.contains(name)) return;
        if (this.operatorSet.contains(name)) return;
        if (this.isComponentN(name)) return;
        emit.invoke((Object)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)importDirective)), (Object)"Unused import", (Object)true);
        if (!autoCorrect) return;
        importDirective.delete();
    }

    private final boolean isComponentN(@NotNull String $receiver) {
        return this.componentNRegex.matches((CharSequence)$receiver);
    }

    public NoUnusedImportsRule() {
        super("no-unused-imports");
        Set set;
        NoUnusedImportsRule noUnusedImportsRule = this;
        noUnusedImportsRule.ref = set = (Set)new LinkedHashSet();
        this.packageName = "";
    }

    public static final /* synthetic */ Set access$getRef$p(NoUnusedImportsRule $this) {
        return $this.ref;
    }
}

