/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00060\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/SpacingAroundOperatorsRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "tokenSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class SpacingAroundOperatorsRule
extends Rule {
    private final TokenSet tokenSet;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (!(!this.tokenSet.contains(node.getElementType()) || !(node instanceof LeafPsiElement) || PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtPrefixExpression.class)) || PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtTypeArgumentList.class)) || Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)KtTokens.MUL) && PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtValueArgument.class)) || PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtImportDirective.class)) || PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtSuperExpression.class)))) {
            boolean spacingAfter;
            KtTypeParameterList ktTypeParameterList;
            if ((Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)KtTokens.GT) || Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)KtTokens.LT)) && Intrinsics.areEqual((ktTypeParameterList = (KtTypeParameterList)PsiUtilsKt.getNonStrictParentOfType((PsiElement)((PsiElement)node), KtTypeParameterList.class)) != null && (ktTypeParameterList = ktTypeParameterList.getParent()) != null && (ktTypeParameterList = ktTypeParameterList.getNode()) != null ? ktTypeParameterList.getElementType() : null, (Object)KtStubElementTypes.FUNCTION) ^ true) {
                return;
            }
            boolean spacingBefore = PsiTreeUtil.prevLeaf((PsiElement)((PsiElement)node), (boolean)true) instanceof PsiWhiteSpace || Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)KtTokens.GT);
            boolean bl = spacingAfter = PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)node), (boolean)true) instanceof PsiWhiteSpace || Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)KtTokens.LT);
            if (!spacingBefore && !spacingAfter) {
                emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)("Missing spacing around \"" + ((LeafPsiElement)node).getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawInsertBeforeMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                    ((LeafPsiElement)node).rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                }
            } else if (!spacingBefore) {
                emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)("Missing spacing before \"" + ((LeafPsiElement)node).getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawInsertBeforeMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                }
            } else if (!spacingAfter) {
                emit.invoke((Object)(((LeafPsiElement)node).getStartOffset() + 1), (Object)("Missing spacing after \"" + ((LeafPsiElement)node).getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)" "));
                }
            }
        }
    }

    public SpacingAroundOperatorsRule() {
        super("op-spacing");
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.MUL, (IElementType)KtTokens.PLUS, (IElementType)KtTokens.MINUS, (IElementType)KtTokens.DIV, (IElementType)KtTokens.PERC, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (IElementType)KtTokens.LTEQ, (IElementType)KtTokens.GTEQ, (IElementType)KtTokens.EQEQEQ, (IElementType)KtTokens.EXCLEQEQEQ, (IElementType)KtTokens.EQEQ, (IElementType)KtTokens.EXCLEQ, (IElementType)KtTokens.ANDAND, (IElementType)KtTokens.OROR, (IElementType)KtTokens.ELVIS, (IElementType)KtTokens.EQ, (IElementType)KtTokens.MULTEQ, (IElementType)KtTokens.DIVEQ, (IElementType)KtTokens.PERCEQ, (IElementType)KtTokens.PLUSEQ, (IElementType)KtTokens.MINUSEQ, (IElementType)KtTokens.ARROW});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(MUL, PLU\u2026, PLUSEQ, MINUSEQ, ARROW)");
        this.tokenSet = tokenSet;
    }
}

