/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data;

import com.github.signaflo.data.DataSet;
import com.github.signaflo.math.operations.Operators;
import com.github.signaflo.math.stats.Statistics;
import java.text.DecimalFormat;
import java.util.Arrays;
import lombok.NonNull;

public final class DoubleDataSet
implements DataSet {
    private final double[] data;

    public DoubleDataSet(double ... data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = (double[])data.clone();
    }

    @Override
    public final double sum() {
        return Statistics.sumOf((double[])this.data);
    }

    @Override
    public final double sumOfSquares() {
        return Statistics.sumOfSquared((double[])this.data);
    }

    @Override
    public final double mean() {
        return Statistics.meanOf((double[])this.data);
    }

    @Override
    public final double median() {
        return Statistics.medianOf((double[])this.data);
    }

    @Override
    public final int size() {
        return this.data.length;
    }

    @Override
    public final DataSet times(@NonNull DataSet otherData) {
        if (otherData == null) {
            throw new NullPointerException("otherData");
        }
        return new DoubleDataSet(Operators.productOf((double[])this.data, (double[])otherData.asArray()));
    }

    @Override
    public final DataSet plus(@NonNull DataSet otherData) {
        if (otherData == null) {
            throw new NullPointerException("otherData");
        }
        return new DoubleDataSet(Operators.sumOf((double[])this.data, (double[])otherData.asArray()));
    }

    @Override
    public final double variance() {
        return Statistics.varianceOf((double[])this.data);
    }

    @Override
    public final double stdDeviation() {
        return Statistics.stdDeviationOf((double[])this.data);
    }

    @Override
    public final double covariance(@NonNull DataSet otherData) {
        if (otherData == null) {
            throw new NullPointerException("otherData");
        }
        return Statistics.covarianceOf((double[])this.data, (double[])otherData.asArray());
    }

    @Override
    public final double correlation(@NonNull DataSet otherData) {
        if (otherData == null) {
            throw new NullPointerException("otherData");
        }
        return Statistics.correlationOf((double[])this.data, (double[])otherData.asArray());
    }

    @Override
    public final double[] asArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.##");
        return "\nValues: " + Arrays.toString(this.data) + "\nLength: " + this.data.length + "\nMean: " + this.mean() + "\nStandard deviation: " + df.format(this.stdDeviation());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleDataSet other = (DoubleDataSet)obj;
        return Arrays.equals(this.data, other.data);
    }
}

