/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data;

import lombok.NonNull;

public final class DoublePair
implements Comparable<DoublePair> {
    private final double first;
    private final double second;

    public DoublePair(double first, double second) {
        this.first = first;
        this.second = second;
    }

    public double first() {
        return this.first;
    }

    public double second() {
        return this.second;
    }

    @Override
    public int compareTo(@NonNull DoublePair otherPair) {
        if (otherPair == null) {
            throw new NullPointerException("otherPair");
        }
        int result = Double.compare(this.first, otherPair.first);
        if (result != 0) {
            return result;
        }
        return Double.compare(this.second, otherPair.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoublePair that = (DoublePair)o;
        if (Double.compare(that.first, this.first) != 0) {
            return false;
        }
        return Double.compare(that.second, this.second) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.first);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.second);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "(" + Double.toString(this.first) + ", " + Double.toString(this.second) + ")";
    }
}

