/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries;

import com.github.signaflo.timeseries.TimePeriod;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public enum TimeUnit {
    CENTURY(ChronoUnit.CENTURIES, 1L),
    DECADE(ChronoUnit.DECADES, 1L),
    YEAR(ChronoUnit.YEARS, 1L),
    QUARTER(ChronoUnit.MONTHS, 3L),
    MONTH(ChronoUnit.MONTHS, 1L),
    WEEK(ChronoUnit.WEEKS, 1L),
    DAY(ChronoUnit.DAYS, 1L),
    HOUR(ChronoUnit.HOURS, 1L),
    MINUTE(ChronoUnit.MINUTES, 1L),
    SECOND(ChronoUnit.SECONDS, 1L),
    MILLISECOND(ChronoUnit.MILLIS, 1L),
    MICROSECOND(ChronoUnit.MICROS, 1L),
    NANOSECOND(ChronoUnit.NANOS, 1L);

    private final TemporalUnit temporalUnit;
    private final long unitLength;

    private TimeUnit(TemporalUnit timeUnit, long unitLength) {
        this.temporalUnit = timeUnit;
        this.unitLength = unitLength;
    }

    public TemporalUnit temporalUnit() {
        return this.temporalUnit;
    }

    public long unitLength() {
        return this.unitLength;
    }

    public double frequencyPer(TimeUnit otherTimeUnit) {
        return otherTimeUnit.totalDuration() / this.totalDuration();
    }

    public double frequencyPer(TimePeriod timePeriod) {
        return timePeriod.totalSeconds() / this.totalDuration();
    }

    double totalDuration() {
        double nanoSecondsPerSecond = 1.0E9;
        Duration thisDuration = this.temporalUnit.getDuration();
        return (double)(thisDuration.getSeconds() * this.unitLength) + (double)((long)thisDuration.getNano() * this.unitLength) / 1.0E9;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

