/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model;

import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;
import com.github.signaflo.timeseries.model.MeanForecaster;
import com.github.signaflo.timeseries.model.Model;
import lombok.NonNull;

public final class MeanModel
implements Model {
    private final TimeSeries timeSeries;
    private final TimeSeries fittedSeries;
    private final double mean;

    public MeanModel(@NonNull TimeSeries observed) {
        if (observed == null) {
            throw new NullPointerException("observed");
        }
        this.timeSeries = observed;
        this.mean = this.timeSeries.mean();
        this.fittedSeries = TimeSeries.from(observed.timePeriod(), observed.observationTimes().get(0), DoubleFunctions.fill((int)observed.size(), (double)this.mean));
    }

    @Override
    public Forecast forecast(int steps, double alpha) {
        MeanForecaster forecaster = new MeanForecaster(this.timeSeries);
        return forecaster.forecast(steps, alpha);
    }

    @Override
    public TimeSeries observations() {
        return this.timeSeries;
    }

    @Override
    public TimeSeries fittedSeries() {
        return this.fittedSeries;
    }

    @Override
    public TimeSeries predictionErrors() {
        return this.timeSeries.minus(this.fittedSeries);
    }

    public String toString() {
        return "Mean model with estimated mean of " + this.mean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanModel meanModel = (MeanModel)o;
        if (Double.compare(meanModel.mean, this.mean) != 0) {
            return false;
        }
        if (!this.timeSeries.equals(meanModel.timeSeries)) {
            return false;
        }
        return this.fittedSeries.equals(meanModel.fittedSeries);
    }

    public int hashCode() {
        int result = this.timeSeries.hashCode();
        result = 31 * result + this.fittedSeries.hashCode();
        long temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

