/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model;

import com.github.signaflo.math.stats.distributions.Normal;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;
import com.github.signaflo.timeseries.forecast.Forecaster;
import com.github.signaflo.timeseries.model.RandomWalkForecast;
import java.time.OffsetDateTime;

class RandomWalkForecaster
implements Forecaster {
    private final TimeSeries timeSeries;
    private final TimeSeries predictionErrors;

    RandomWalkForecaster(TimeSeries observations, TimeSeries predictionErrors) {
        this.timeSeries = observations;
        this.predictionErrors = predictionErrors;
    }

    @Override
    public TimeSeries computeUpperPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        double[] upperPredictionValues = new double[steps];
        double criticalValue = new Normal(0.0, this.predictionErrors.stdDeviation()).quantile(1.0 - alpha / 2.0);
        for (int t = 0; t < steps; ++t) {
            upperPredictionValues[t] = forecast.at(t) + criticalValue * Math.sqrt(t + 1);
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.observationTimes().get(0), upperPredictionValues);
    }

    @Override
    public TimeSeries computeLowerPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        double[] upperPredictionValues = new double[steps];
        double criticalValue = new Normal(0.0, this.predictionErrors.stdDeviation()).quantile(1.0 - alpha / 2.0);
        for (int t = 0; t < steps; ++t) {
            upperPredictionValues[t] = forecast.at(t) - criticalValue * Math.sqrt(t + 1);
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.observationTimes().get(0), upperPredictionValues);
    }

    @Override
    public TimeSeries computePointForecasts(int steps) {
        int n = this.timeSeries.size();
        TimePeriod timePeriod = this.timeSeries.timePeriod();
        long amountToAdd = timePeriod.periodLength() * timePeriod.timeUnit().unitLength();
        OffsetDateTime startTime = this.timeSeries.observationTimes().get(n - 1).plus(amountToAdd, timePeriod.timeUnit().temporalUnit());
        double[] forecast = new double[steps];
        for (int t = 0; t < steps; ++t) {
            forecast[t] = this.timeSeries.at(n - 1);
        }
        return TimeSeries.from(timePeriod, startTime, forecast);
    }

    @Override
    public Forecast forecast(int steps, double alpha) {
        TimeSeries forecast = this.computePointForecasts(steps);
        TimeSeries lowerBounds = this.computeLowerPredictionBounds(forecast, steps, alpha);
        TimeSeries upperBounds = this.computeUpperPredictionBounds(forecast, steps, alpha);
        return new RandomWalkForecast(forecast, lowerBounds, upperBounds);
    }
}

