/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;

final class ArimaForecast
implements Forecast {
    private final TimeSeries pointForecast;
    private final TimeSeries lowerValues;
    private final TimeSeries upperValues;
    private final double alpha;

    ArimaForecast(TimeSeries pointForecast, TimeSeries lowerValues, TimeSeries upperValues, double alpha) {
        this.pointForecast = pointForecast;
        this.lowerValues = lowerValues;
        this.upperValues = upperValues;
        this.alpha = alpha;
    }

    @Override
    public TimeSeries pointEstimates() {
        return this.pointForecast;
    }

    @Override
    public TimeSeries upperPredictionInterval() {
        return this.upperValues;
    }

    @Override
    public TimeSeries lowerPredictionInterval() {
        return this.lowerValues;
    }

    public String toString() {
        String newLine = System.lineSeparator();
        StringBuilder builder = new StringBuilder(newLine);
        builder.append(String.format("%-18.18s", "| Date ")).append("  ").append(String.format("%-13.13s", "| Forecast ")).append("  ").append(String.format("%-13.13s", "| Lower " + String.format("%.1f", (1.0 - this.alpha) * 100.0) + "%")).append("  ").append(String.format("%-13.13s", "| Upper " + String.format("%.1f", (1.0 - this.alpha) * 100.0) + "%")).append(" |").append(newLine).append(String.format("%-70.70s", " -------------------------------------------------------------- ")).append(newLine);
        for (int i = 0; i < this.pointForecast.size(); ++i) {
            builder.append(String.format("%-18.18s", "| " + this.pointForecast.observationTimes().get(i).toLocalDateTime())).append("  ").append(String.format("%-13.13s", "| " + Double.toString(this.pointForecast.at(i)))).append("  ").append(String.format("%-13.13s", "| " + Double.toString(this.lowerValues.at(i)))).append("  ").append(String.format("%-13.13s", "| " + Double.toString(this.upperValues.at(i)))).append(" |").append(newLine);
        }
        return builder.toString();
    }
}

