/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.model.arima.ArimaStateSpace;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

class ArimaKalmanFilter {
    private final double[] y;
    private final int r;
    private final int d;
    private final int rd;
    private final DenseMatrix64F transitionMatrix;
    private final RowD1Matrix64F stateDisturbance;
    private final RowD1Matrix64F predictedState;
    private final RowD1Matrix64F filteredState;
    private final DenseMatrix64F predictedStateCovariance;
    private final RowD1Matrix64F filteredStateCovariance;
    private final double[] predictionErrorVariance;
    private final double[] predictionError;
    private final DenseMatrix64F Z;
    private final DenseMatrix64F Zt;
    private final DenseMatrix64F ZP;
    private DenseMatrix64F PZtf;
    private final DenseMatrix64F PZtfZ;
    private final KalmanOutput kalmanOutput;

    ArimaKalmanFilter(ArimaStateSpace ss) {
        this.y = ss.observations();
        this.r = ss.r();
        this.d = ss.d();
        this.rd = this.r + this.d;
        this.transitionMatrix = new DenseMatrix64F(ss.transitionMatrix());
        DenseMatrix64F R = new DenseMatrix64F(this.rd, 1, true, ss.movingAverageVector());
        this.stateDisturbance = new DenseMatrix64F(this.rd, this.rd);
        CommonOps.multOuter((RowD1Matrix64F)R, (RowD1Matrix64F)this.stateDisturbance);
        this.predictedState = new DenseMatrix64F(this.rd, 1, true, new double[this.rd]);
        this.filteredState = new DenseMatrix64F(this.rd, 1, true, new double[this.rd]);
        this.predictedStateCovariance = this.initializePredictedCovariance(ss);
        this.filteredStateCovariance = new DenseMatrix64F(this.rd, this.rd);
        this.predictionErrorVariance = new double[this.y.length];
        this.predictionError = new double[this.y.length];
        this.Z = new DenseMatrix64F(1, this.rd, true, ss.stateEffectsVector());
        this.Zt = new DenseMatrix64F(this.rd, 1, true, new double[this.rd]);
        this.ZP = new DenseMatrix64F(1, this.rd, true, new double[this.rd]);
        this.PZtf = new DenseMatrix64F(this.rd, 1, true, new double[this.rd]);
        this.PZtfZ = new DenseMatrix64F(this.rd, this.rd, true, new double[this.rd * this.rd]);
        this.kalmanOutput = this.filter();
    }

    private KalmanOutput filter() {
        int n = 0;
        this.predictionError[0] = this.y[0];
        CommonOps.mult((RowD1Matrix64F)this.Z, (RowD1Matrix64F)this.predictedStateCovariance, (RowD1Matrix64F)this.ZP);
        CommonOps.transpose((DenseMatrix64F)this.Z, (DenseMatrix64F)this.Zt);
        this.predictionErrorVariance[0] = CommonOps.dot((D1Matrix64F)this.ZP, (D1Matrix64F)this.Zt);
        double f = this.predictionErrorVariance[0];
        double ssq = 0.0;
        double sumlog = 0.0;
        if (f < 10000.0) {
            ++n;
            ssq = this.predictionError[0] * this.predictionError[0] / f;
            sumlog = Math.log(f);
        }
        DenseMatrix64F newInfo = new DenseMatrix64F(this.rd, 1, true, new double[this.rd]);
        CommonOps.transpose((DenseMatrix64F)this.ZP, (DenseMatrix64F)newInfo);
        CommonOps.divide((D1Matrix64F)newInfo, (double)f);
        this.PZtf = newInfo.copy();
        CommonOps.scale((double)this.predictionError[0], (D1Matrix64F)newInfo);
        CommonOps.add((D1Matrix64F)this.predictedState, (D1Matrix64F)newInfo, (D1Matrix64F)this.filteredState);
        DenseMatrix64F adjustedPredictionCovariance = new DenseMatrix64F(this.rd, this.rd);
        CommonOps.mult((RowD1Matrix64F)this.PZtf, (RowD1Matrix64F)this.Z, (RowD1Matrix64F)this.PZtfZ);
        CommonOps.mult((RowD1Matrix64F)this.PZtfZ, (RowD1Matrix64F)this.predictedStateCovariance, (RowD1Matrix64F)adjustedPredictionCovariance);
        CommonOps.subtract((D1Matrix64F)this.predictedStateCovariance, (D1Matrix64F)adjustedPredictionCovariance, (D1Matrix64F)this.filteredStateCovariance);
        DenseMatrix64F filteredCovarianceTransition = new DenseMatrix64F(this.rd, this.rd);
        DenseMatrix64F stateCovarianceTransition = new DenseMatrix64F(this.rd, this.rd);
        DenseMatrix64F transitionTranspose = this.transitionMatrix.copy();
        CommonOps.transpose((DenseMatrix64F)transitionTranspose);
        this.predictionError[0] = this.predictionError[0] / Math.sqrt(f);
        int t = 1;
        while (t < this.y.length) {
            CommonOps.mult((RowD1Matrix64F)this.transitionMatrix, (RowD1Matrix64F)this.filteredState, (RowD1Matrix64F)this.predictedState);
            CommonOps.mult((RowD1Matrix64F)this.transitionMatrix, (RowD1Matrix64F)this.filteredStateCovariance, (RowD1Matrix64F)filteredCovarianceTransition);
            CommonOps.mult((RowD1Matrix64F)filteredCovarianceTransition, (RowD1Matrix64F)transitionTranspose, (RowD1Matrix64F)stateCovarianceTransition);
            CommonOps.add((D1Matrix64F)stateCovarianceTransition, (D1Matrix64F)this.stateDisturbance, (D1Matrix64F)this.predictedStateCovariance);
            this.predictionError[t] = this.y[t] - CommonOps.dot((D1Matrix64F)this.Z, (D1Matrix64F)this.predictedState);
            CommonOps.mult((RowD1Matrix64F)this.Z, (RowD1Matrix64F)this.predictedStateCovariance, (RowD1Matrix64F)this.ZP);
            this.predictionErrorVariance[t] = CommonOps.dot((D1Matrix64F)this.ZP, (D1Matrix64F)this.Zt);
            f = this.predictionErrorVariance[t];
            if (f < 10000.0) {
                ++n;
                ssq += this.predictionError[t] * this.predictionError[t] / f;
                sumlog += Math.log(f);
            }
            CommonOps.transpose((DenseMatrix64F)this.ZP, (DenseMatrix64F)newInfo);
            CommonOps.divide((D1Matrix64F)newInfo, (double)f);
            this.PZtf = newInfo.copy();
            CommonOps.scale((double)this.predictionError[t], (D1Matrix64F)newInfo);
            CommonOps.add((D1Matrix64F)this.predictedState, (D1Matrix64F)newInfo, (D1Matrix64F)this.filteredState);
            CommonOps.mult((RowD1Matrix64F)this.PZtf, (RowD1Matrix64F)this.Z, (RowD1Matrix64F)this.PZtfZ);
            CommonOps.mult((RowD1Matrix64F)this.PZtfZ, (RowD1Matrix64F)this.predictedStateCovariance, (RowD1Matrix64F)adjustedPredictionCovariance);
            CommonOps.subtract((D1Matrix64F)this.predictedStateCovariance, (D1Matrix64F)adjustedPredictionCovariance, (D1Matrix64F)this.filteredStateCovariance);
            int n2 = t++;
            this.predictionError[n2] = this.predictionError[n2] / Math.sqrt(f);
        }
        return new KalmanOutput(n, ssq, sumlog, this.predictionError);
    }

    private DenseMatrix64F initializePredictedCovariance(ArimaStateSpace ss) {
        DenseMatrix64F P0 = new DenseMatrix64F(this.rd, this.rd);
        double[] P = ArimaKalmanFilter.getInitialStateCovariance(ss.arParams(), ss.maParams());
        DenseMatrix64F arMatrix = new DenseMatrix64F(this.r, this.r, true, ArimaKalmanFilter.unpack(P));
        double[] kappa = new double[this.d * this.d];
        for (int i = 0; i < this.d; ++i) {
            kappa[i * this.d + i] = 1000000.0;
        }
        DenseMatrix64F kappaMatrix = new DenseMatrix64F(this.d, this.d, true, kappa);
        CommonOps.insert((RealMatrix64F)arMatrix, (RealMatrix64F)P0, (int)0, (int)0);
        CommonOps.insert((RealMatrix64F)kappaMatrix, (RealMatrix64F)P0, (int)this.r, (int)this.r);
        return P0;
    }

    private static double[] getInitialStateCovariance(double[] phi, double[] theta) {
        int i;
        int i2;
        int p = phi.length;
        int q = theta.length;
        if (p == 0 && q == 0) {
            return new double[]{1.0};
        }
        int r = Math.max(p, q + 1);
        int np = r * (r + 1) / 2;
        double[] P = new double[np];
        double[] V = new double[np];
        double[] xrow = new double[np];
        int nrbar = np * (np - 1) / 2;
        int fault = ArimaKalmanFilter.validate(p, q, r, np, nrbar);
        if (fault != 0) {
            throw new RuntimeException("Validation Error # " + fault);
        }
        for (int i3 = 1; i3 < r; ++i3) {
            V[i3] = 0.0;
            if (i3 > q) continue;
            V[i3] = theta[i3 - 1];
        }
        V[0] = 1.0;
        int index = r;
        for (int j = 1; j < r; ++j) {
            double vj = V[j];
            for (i2 = j; i2 < r; ++i2) {
                V[index++] = V[i2] * vj;
            }
        }
        if (p == 0) {
            int indexn = np;
            index = np;
            for (i2 = 0; i2 < r; ++i2) {
                for (int j = 0; j <= i2; ++j) {
                    P[--index] = V[index];
                    if (j == 0) continue;
                    int n = index;
                    P[n] = P[n] + P[--indexn];
                }
            }
            return P;
        }
        double[] rbar = new double[nrbar];
        double[] thetab = new double[np];
        double[] xnext = new double[np];
        index = 0;
        int index1 = -1;
        int npr = np - r;
        int npr1 = npr + 1;
        int indexj = npr;
        int index2 = npr - 1;
        for (int j = 0; j < r; ++j) {
            double phij = j < p ? phi[j] : 0.0;
            xnext[indexj++] = 0.0;
            int indexi = npr1 + j;
            for (int i4 = j; i4 < r; ++i4) {
                double phii;
                double ynext = V[index++];
                double d = phii = i4 < p ? phi[i4] : 0.0;
                if (j != r - 1) {
                    xnext[indexj] = -phii;
                    if (i4 != r - 1) {
                        int n = indexi;
                        xnext[n] = xnext[n] - phij;
                        xnext[++index1] = -1.0;
                    }
                }
                xnext[npr] = -phii * phij;
                if (++index2 >= np) {
                    index2 = 0;
                }
                int n = index2;
                xnext[n] = xnext[n] + 1.0;
                ArimaKalmanFilter.inclu2(np, xnext, xrow, ynext, P, rbar, thetab);
                xnext[index2] = 0.0;
                if (i4 == r - 1) continue;
                xnext[indexi++] = 0.0;
                xnext[index1] = 0.0;
            }
        }
        ArimaKalmanFilter.regres(np, nrbar, rbar, thetab, P);
        index = npr;
        for (i = 0; i < r; ++i) {
            xnext[i] = P[index++];
        }
        index = np - 1;
        index1 = npr - 1;
        for (i = 0; i < npr; ++i) {
            P[index--] = P[index1--];
        }
        System.arraycopy(xnext, 0, P, 0, r);
        return P;
    }

    private static int validate(int ip, int iq, int ir, int np, int nrbar) {
        if (ip == 0 && iq == 0) {
            return 4;
        }
        if (np != ir * (ir + 1) / 2) {
            return 6;
        }
        if (nrbar != np * (np - 1) / 2) {
            return 7;
        }
        return 0;
    }

    private static void inclu2(int np, double[] xnext, double[] xrow, double ynext, double[] d, double[] rbar, double[] thetab) {
        System.arraycopy(xnext, 0, xrow, 0, np);
        int ithisr = 0;
        double y = ynext;
        double wt = 1.0;
        for (int i = 0; i < np; ++i) {
            if (xrow[i] != 0.0) {
                double xk;
                double dpi;
                double xi = xrow[i];
                double di = d[i];
                d[i] = dpi = di + wt * xi * xi;
                double cbar = di / dpi;
                double sbar = wt * xi / dpi;
                wt = cbar * wt;
                if (i != np - 1) {
                    int i1;
                    for (int k = i1 = i + 1; k < np; ++k) {
                        xk = xrow[k];
                        double rbthis = rbar[ithisr];
                        xrow[k] = xk - xi * rbthis;
                        rbar[ithisr++] = cbar * rbthis + sbar * xk;
                    }
                }
                xk = y;
                y = xk - xi * thetab[i];
                thetab[i] = cbar * thetab[i] + sbar * xk;
                if (di != 0.0) continue;
                return;
            }
            ithisr = ithisr + np - i - 1;
        }
    }

    private static void regres(int np, int nrbar, double[] rbar, double[] thetab, double[] beta) {
        int ithisr = nrbar - 1;
        int im = np - 1;
        for (int i = 0; i < np; ++i) {
            double bi = thetab[im];
            if (im != np - 1) {
                int i1 = i;
                int jm = np - 1;
                for (int j = 0; j < i1; ++j) {
                    bi -= rbar[ithisr] * beta[jm];
                    --ithisr;
                    --jm;
                }
            }
            beta[im] = bi;
            --im;
        }
    }

    private static double[] unpack(double[] triangularMatrix) {
        int j;
        int c = triangularMatrix.length;
        int r = (-1 + (int)Math.sqrt(1 + 8 * c)) / 2;
        double[] full = new double[r * r];
        int k = 0;
        int indext = 0;
        int i = 0;
        while (i < r) {
            for (j = 0; j < r - k; ++j) {
                full[j + k + i * r] = triangularMatrix[indext++];
            }
            ++i;
            ++k;
        }
        for (i = 0; i < r - 1; ++i) {
            for (j = i + 1; j < r; ++j) {
                full[i + r * j] = full[j + i * r];
            }
        }
        return full;
    }

    KalmanOutput output() {
        return this.kalmanOutput;
    }

    double[] predictionError() {
        return (double[])this.predictionError.clone();
    }

    double ssq() {
        return this.kalmanOutput.ssq();
    }

    int n() {
        return this.kalmanOutput.n();
    }

    double sumLog() {
        return this.kalmanOutput.sumLog();
    }

    double logLikelihood() {
        return this.kalmanOutput.logLikelihood();
    }

    static class KalmanOutput {
        private final int n;
        private final double ssq;
        private final double sumlog;
        private final double sigma2;
        private final double logLikelihood;
        private final double[] residuals;

        KalmanOutput(int n, double ssq, double sumlog, double[] residuals) {
            this.n = n;
            this.ssq = ssq;
            this.sumlog = sumlog;
            this.sigma2 = ssq / (double)n;
            this.logLikelihood = (double)(-n) / 2.0 * (Math.log(Math.PI * 2 * this.sigma2) + 1.0) - 0.5 * sumlog;
            this.residuals = (double[])residuals.clone();
        }

        double ssq() {
            return this.ssq;
        }

        int n() {
            return this.n;
        }

        double sumLog() {
            return this.sumlog;
        }

        double sigma2() {
            return this.sigma2;
        }

        double logLikelihood() {
            return this.logLikelihood;
        }

        double[] residuals() {
            return (double[])this.residuals.clone();
        }
    }
}

