/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.model.arima.Arima;

public class ArimaOrder {
    private final int p;
    private final int d;
    private final int q;
    private final int P;
    private final int D;
    private final int Q;
    private final Arima.Constant constant;
    private final Arima.Drift drift;
    private final int sumARMA;
    private final int npar;
    private final int numRegressors;

    ArimaOrder(int p, int d, int q, int P, int D, int Q, Arima.Constant constant, Arima.Drift drift) {
        this.p = p;
        this.d = d;
        this.q = q;
        this.P = P;
        this.D = D;
        this.Q = Q;
        this.constant = constant;
        this.drift = drift;
        this.sumARMA = this.p + this.q + this.P + this.Q;
        this.numRegressors = constant.asInt() + drift.asInt();
        this.npar = this.sumARMA + this.numRegressors;
    }

    public static ArimaOrder order(int p, int d, int q) {
        Arima.Constant constant = d == 0 ? Arima.Constant.INCLUDE : Arima.Constant.EXCLUDE;
        return new ArimaOrder(p, d, q, 0, 0, 0, constant, Arima.Drift.EXCLUDE);
    }

    public static ArimaOrder order(int p, int d, int q, Arima.Constant constant) {
        return new ArimaOrder(p, d, q, 0, 0, 0, constant, Arima.Drift.EXCLUDE);
    }

    public static ArimaOrder order(int p, int d, int q, Arima.Drift drift) {
        Arima.Constant constant = d > 0 && drift.include() ? Arima.Constant.EXCLUDE : Arima.Constant.INCLUDE;
        return new ArimaOrder(p, d, q, 0, 0, 0, constant, drift);
    }

    public static ArimaOrder order(int p, int d, int q, Arima.Constant constant, Arima.Drift drift) {
        if (d > 0 && constant.include() && drift.include()) {
            throw new IllegalArgumentException("Arima model cannot be fit with both a constant and a drift term when the degree of differencing is greater than zero.");
        }
        return new ArimaOrder(p, d, q, 0, 0, 0, constant, drift);
    }

    public static ArimaOrder order(int p, int d, int q, int P, int D, int Q) {
        Arima.Constant constant = d == 0 && D == 0 ? Arima.Constant.INCLUDE : Arima.Constant.EXCLUDE;
        return new ArimaOrder(p, d, q, P, D, Q, constant, Arima.Drift.EXCLUDE);
    }

    public static ArimaOrder order(int p, int d, int q, int P, int D, int Q, Arima.Constant constant) {
        return new ArimaOrder(p, d, q, P, D, Q, constant, Arima.Drift.EXCLUDE);
    }

    public static ArimaOrder order(int p, int d, int q, int P, int D, int Q, Arima.Drift drift) {
        Arima.Constant constant = d + D > 0 ? Arima.Constant.EXCLUDE : Arima.Constant.INCLUDE;
        return new ArimaOrder(p, d, q, P, D, Q, constant, drift);
    }

    public static ArimaOrder order(int p, int d, int q, int P, int D, int Q, Arima.Constant constant, Arima.Drift drift) {
        if ((d > 0 || D > 0) && constant.include() && drift.include()) {
            throw new IllegalArgumentException("Arima model cannot be fit with both a constant and a drift term when the degree of differencing is greater than zero.");
        }
        return new ArimaOrder(p, d, q, P, D, Q, constant, drift);
    }

    int p() {
        return this.p;
    }

    int q() {
        return this.q;
    }

    int P() {
        return this.P;
    }

    int Q() {
        return this.Q;
    }

    int d() {
        return this.d;
    }

    int D() {
        return this.D;
    }

    Arima.Constant constant() {
        return this.constant;
    }

    Arima.Drift drift() {
        return this.drift;
    }

    int sumARMA() {
        return this.sumARMA;
    }

    int npar() {
        return this.npar;
    }

    int numRegressors() {
        return this.numRegressors;
    }

    public String toString() {
        boolean isSeasonal = this.P > 0 || this.Q > 0 || this.D > 0;
        StringBuilder builder = new StringBuilder();
        if (isSeasonal) {
            builder.append("Seasonal ");
        }
        builder.append("ARIMA (").append(this.p).append(", ").append(this.d).append(", ").append(this.q);
        if (isSeasonal) {
            builder.append(") x (").append(this.P).append(", ").append(this.D).append(", ").append(this.Q);
        }
        builder.append(") with").append(this.constant == Arima.Constant.INCLUDE ? " a constant" : " no constant");
        builder.append(this.drift == Arima.Drift.INCLUDE ? " and drift" : "");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.D;
        result = 31 * result + this.P;
        result = 31 * result + this.Q;
        result = 31 * result + this.constant.asInt();
        result = 31 * result + this.drift.asInt();
        result = 31 * result + this.d;
        result = 31 * result + this.p;
        result = 31 * result + this.q;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArimaOrder other = (ArimaOrder)obj;
        if (this.D != other.D) {
            return false;
        }
        if (this.P != other.P) {
            return false;
        }
        if (this.Q != other.Q) {
            return false;
        }
        if (this.constant != other.constant) {
            return false;
        }
        if (this.drift != other.drift) {
            return false;
        }
        if (this.d != other.d) {
            return false;
        }
        return this.p == other.p && this.q == other.q;
    }
}

