/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.model.arima.ArimaCoefficients;
import com.github.signaflo.timeseries.model.arima.ArimaOrder;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.NonNull;

final class ArimaParameters {
    private static final double EPSILON = Math.ulp(1.0);
    @NonNull
    private double[] autoRegressivePars;
    @NonNull
    private double[] movingAveragePars;
    @NonNull
    private double[] seasonalAutoRegressivePars;
    @NonNull
    private double[] seasonalMovingAveragePars;
    private double mean = 0.0;
    private double intercept = 0.0;
    private double drift = 0.0;
    private double meanParScale = 1.0;
    private double interceptParScale = 1.0;
    private double driftParScale = 1.0;

    void setAndScaleMean(double meanFactor) {
        this.mean = meanFactor * this.meanParScale;
    }

    void setAndScaleIntercept(double interceptFactor) {
        this.intercept = interceptFactor * this.interceptParScale;
    }

    void setAndScaleDrift(double driftFactor) {
        this.drift = driftFactor * this.driftParScale;
    }

    double[] getRegressors(ArimaOrder order) {
        double[] regressors = new double[order.npar() - order.sumARMA()];
        if (order.constant().include()) {
            regressors[0] = this.mean;
        }
        if (order.drift().include()) {
            regressors[order.constant().asInt()] = this.drift;
        }
        return regressors;
    }

    double[] getAll(ArimaOrder order) {
        double[] pars = new double[order.npar()];
        System.arraycopy(this.autoRegressivePars, 0, pars, 0, this.autoRegressivePars.length);
        System.arraycopy(this.movingAveragePars, 0, pars, order.p(), this.movingAveragePars.length);
        System.arraycopy(this.seasonalAutoRegressivePars, 0, pars, order.p() + order.q(), this.seasonalAutoRegressivePars.length);
        System.arraycopy(this.seasonalMovingAveragePars, 0, pars, order.p() + order.q() + order.P(), this.seasonalMovingAveragePars.length);
        if (order.constant().include()) {
            pars[order.sumARMA()] = this.mean;
        }
        if (order.drift().include()) {
            pars[order.sumARMA() + order.constant().asInt()] = this.drift;
        }
        return pars;
    }

    double[] getAllScaled(ArimaOrder order) {
        double[] pars = new double[order.npar()];
        System.arraycopy(this.autoRegressivePars, 0, pars, 0, this.autoRegressivePars.length);
        System.arraycopy(this.movingAveragePars, 0, pars, order.p(), this.movingAveragePars.length);
        System.arraycopy(this.seasonalAutoRegressivePars, 0, pars, order.p() + order.q(), this.seasonalAutoRegressivePars.length);
        System.arraycopy(this.seasonalMovingAveragePars, 0, pars, order.p() + order.q() + order.P(), this.seasonalMovingAveragePars.length);
        if (order.constant().include()) {
            pars[order.sumARMA()] = this.mean / (this.meanParScale + EPSILON);
        }
        if (order.drift().include()) {
            pars[order.sumARMA() + order.constant().asInt()] = this.drift / (this.driftParScale + EPSILON);
        }
        return pars;
    }

    static ArimaParameters fromCoefficients(ArimaCoefficients coefficients) {
        ArimaParameters parameters = new ArimaParameters(coefficients.arCoeffs(), coefficients.maCoeffs(), coefficients.seasonalARCoeffs(), coefficients.seasonalMACoeffs());
        parameters.setMean(coefficients.mean());
        parameters.setIntercept(coefficients.intercept());
        parameters.setDrift(coefficients.drift());
        return parameters;
    }

    static ArimaParameters fromOrder(ArimaOrder order) {
        return ArimaParameters.initializePars(order.p(), order.q(), order.P(), order.Q());
    }

    static ArimaParameters initializePars(int numAR, int numMA, int numSAR, int numSMA) {
        double[] autoRegressivePars = new double[numAR];
        double[] movingAveragePars = new double[numMA];
        double[] seasonalAutoRegressivePars = new double[numSAR];
        double[] seasonalMovingAveragePars = new double[numSMA];
        return new ArimaParameters(autoRegressivePars, movingAveragePars, seasonalAutoRegressivePars, seasonalMovingAveragePars);
    }

    @ConstructorProperties(value={"autoRegressivePars", "movingAveragePars", "seasonalAutoRegressivePars", "seasonalMovingAveragePars"})
    public ArimaParameters(@NonNull double[] autoRegressivePars, @NonNull double[] movingAveragePars, @NonNull double[] seasonalAutoRegressivePars, @NonNull double[] seasonalMovingAveragePars) {
        if (autoRegressivePars == null) {
            throw new NullPointerException("autoRegressivePars");
        }
        if (movingAveragePars == null) {
            throw new NullPointerException("movingAveragePars");
        }
        if (seasonalAutoRegressivePars == null) {
            throw new NullPointerException("seasonalAutoRegressivePars");
        }
        if (seasonalMovingAveragePars == null) {
            throw new NullPointerException("seasonalMovingAveragePars");
        }
        this.autoRegressivePars = autoRegressivePars;
        this.movingAveragePars = movingAveragePars;
        this.seasonalAutoRegressivePars = seasonalAutoRegressivePars;
        this.seasonalMovingAveragePars = seasonalMovingAveragePars;
    }

    @NonNull
    public double[] getAutoRegressivePars() {
        return this.autoRegressivePars;
    }

    @NonNull
    public double[] getMovingAveragePars() {
        return this.movingAveragePars;
    }

    @NonNull
    public double[] getSeasonalAutoRegressivePars() {
        return this.seasonalAutoRegressivePars;
    }

    @NonNull
    public double[] getSeasonalMovingAveragePars() {
        return this.seasonalMovingAveragePars;
    }

    public double getMean() {
        return this.mean;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getDrift() {
        return this.drift;
    }

    public double getMeanParScale() {
        return this.meanParScale;
    }

    public double getInterceptParScale() {
        return this.interceptParScale;
    }

    public double getDriftParScale() {
        return this.driftParScale;
    }

    public void setAutoRegressivePars(@NonNull double[] autoRegressivePars) {
        if (autoRegressivePars == null) {
            throw new NullPointerException("autoRegressivePars");
        }
        this.autoRegressivePars = autoRegressivePars;
    }

    public void setMovingAveragePars(@NonNull double[] movingAveragePars) {
        if (movingAveragePars == null) {
            throw new NullPointerException("movingAveragePars");
        }
        this.movingAveragePars = movingAveragePars;
    }

    public void setSeasonalAutoRegressivePars(@NonNull double[] seasonalAutoRegressivePars) {
        if (seasonalAutoRegressivePars == null) {
            throw new NullPointerException("seasonalAutoRegressivePars");
        }
        this.seasonalAutoRegressivePars = seasonalAutoRegressivePars;
    }

    public void setSeasonalMovingAveragePars(@NonNull double[] seasonalMovingAveragePars) {
        if (seasonalMovingAveragePars == null) {
            throw new NullPointerException("seasonalMovingAveragePars");
        }
        this.seasonalMovingAveragePars = seasonalMovingAveragePars;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    public void setDrift(double drift) {
        this.drift = drift;
    }

    public void setMeanParScale(double meanParScale) {
        this.meanParScale = meanParScale;
    }

    public void setInterceptParScale(double interceptParScale) {
        this.interceptParScale = interceptParScale;
    }

    public void setDriftParScale(double driftParScale) {
        this.driftParScale = driftParScale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArimaParameters)) {
            return false;
        }
        ArimaParameters other = (ArimaParameters)o;
        if (!Arrays.equals(this.getAutoRegressivePars(), other.getAutoRegressivePars())) {
            return false;
        }
        if (!Arrays.equals(this.getMovingAveragePars(), other.getMovingAveragePars())) {
            return false;
        }
        if (!Arrays.equals(this.getSeasonalAutoRegressivePars(), other.getSeasonalAutoRegressivePars())) {
            return false;
        }
        if (!Arrays.equals(this.getSeasonalMovingAveragePars(), other.getSeasonalMovingAveragePars())) {
            return false;
        }
        if (Double.compare(this.getMean(), other.getMean()) != 0) {
            return false;
        }
        if (Double.compare(this.getIntercept(), other.getIntercept()) != 0) {
            return false;
        }
        if (Double.compare(this.getDrift(), other.getDrift()) != 0) {
            return false;
        }
        if (Double.compare(this.getMeanParScale(), other.getMeanParScale()) != 0) {
            return false;
        }
        if (Double.compare(this.getInterceptParScale(), other.getInterceptParScale()) != 0) {
            return false;
        }
        return Double.compare(this.getDriftParScale(), other.getDriftParScale()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getAutoRegressivePars());
        result = result * 59 + Arrays.hashCode(this.getMovingAveragePars());
        result = result * 59 + Arrays.hashCode(this.getSeasonalAutoRegressivePars());
        result = result * 59 + Arrays.hashCode(this.getSeasonalMovingAveragePars());
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $intercept = Double.doubleToLongBits(this.getIntercept());
        result = result * 59 + (int)($intercept >>> 32 ^ $intercept);
        long $drift = Double.doubleToLongBits(this.getDrift());
        result = result * 59 + (int)($drift >>> 32 ^ $drift);
        long $meanParScale = Double.doubleToLongBits(this.getMeanParScale());
        result = result * 59 + (int)($meanParScale >>> 32 ^ $meanParScale);
        long $interceptParScale = Double.doubleToLongBits(this.getInterceptParScale());
        result = result * 59 + (int)($interceptParScale >>> 32 ^ $interceptParScale);
        long $driftParScale = Double.doubleToLongBits(this.getDriftParScale());
        result = result * 59 + (int)($driftParScale >>> 32 ^ $driftParScale);
        return result;
    }

    public String toString() {
        return "ArimaParameters(autoRegressivePars=" + Arrays.toString(this.getAutoRegressivePars()) + ", movingAveragePars=" + Arrays.toString(this.getMovingAveragePars()) + ", seasonalAutoRegressivePars=" + Arrays.toString(this.getSeasonalAutoRegressivePars()) + ", seasonalMovingAveragePars=" + Arrays.toString(this.getSeasonalMovingAveragePars()) + ", mean=" + this.getMean() + ", intercept=" + this.getIntercept() + ", drift=" + this.getDrift() + ", meanParScale=" + this.getMeanParScale() + ", interceptParScale=" + this.getInterceptParScale() + ", driftParScale=" + this.getDriftParScale() + ")";
    }
}

