/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.math.stats.distributions.Distribution;
import com.github.signaflo.math.stats.distributions.Normal;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.model.arima.ArimaCoefficients;
import com.github.signaflo.timeseries.operators.LagPolynomial;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.PrimitiveIterator;
import java.util.Queue;
import java.util.function.DoubleSupplier;

public class ArimaProcess
implements DoubleSupplier,
PrimitiveIterator.OfDouble {
    private final ArimaCoefficients coefficients;
    private final Distribution distribution;
    private final TimePeriod period;
    private final TimePeriod seasonalCycle;
    private final OffsetDateTime startTime;
    private OffsetDateTime currentTime;
    private final LagPolynomial maPoly;
    private final LagPolynomial arPoly;
    private final LagPolynomial diffPoly;
    private final Queue<Double> diffSeries;
    private final Queue<Double> series;
    private final Queue<Double> errors;

    private ArimaProcess(Builder builder) {
        this.coefficients = builder.coefficients;
        this.distribution = builder.distribution;
        this.period = builder.period;
        this.seasonalCycle = builder.seasonalCycle;
        this.currentTime = this.startTime = builder.startTime;
        int seasonalFrequency = (int)builder.period.frequencyPer(builder.seasonalCycle);
        double[] arSarCoeffs = ArimaCoefficients.expandArCoefficients(this.coefficients.arCoeffs(), this.coefficients.seasonalARCoeffs(), seasonalFrequency);
        double[] maSmaCoeffs = ArimaCoefficients.expandMaCoefficients(this.coefficients.maCoeffs(), this.coefficients.seasonalMACoeffs(), seasonalFrequency);
        this.errors = EvictingQueue.create((int)maSmaCoeffs.length);
        this.diffSeries = EvictingQueue.create((int)arSarCoeffs.length);
        this.series = EvictingQueue.create((int)(this.coefficients.d() + this.coefficients.D() * seasonalFrequency));
        this.maPoly = LagPolynomial.movingAverage(maSmaCoeffs);
        this.arPoly = LagPolynomial.autoRegressive(arSarCoeffs);
        this.diffPoly = LagPolynomial.differences(this.coefficients.d()).times(LagPolynomial.seasonalDifferences(seasonalFrequency, this.coefficients.D()));
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public double nextDouble() {
        return this.getAsDouble();
    }

    @Override
    public synchronized double getAsDouble() {
        double error;
        double newValue = error = this.distribution.rand();
        double[] series = this.getSeries();
        double[] errors = this.getErrors();
        double[] diffSeries = this.getDiffSeries();
        int p = diffSeries.length;
        int q = errors.length;
        int d = series.length;
        newValue += d == 0 ? this.coefficients.intercept() : this.coefficients.drift();
        newValue += this.arPoly.solve(diffSeries, p);
        this.diffSeries.add(newValue += this.maPoly.solve(errors, q));
        this.series.add(newValue += this.diffPoly.solve(series, d));
        this.errors.add(error);
        this.currentTime = this.currentTime.plus(this.period.unitLength(), this.period.timeUnit().temporalUnit());
        return newValue;
    }

    public synchronized double[] getNext(int n) {
        double[] next = new double[n];
        for (int i = 0; i < n; ++i) {
            next[i] = this.getAsDouble();
        }
        return next;
    }

    public TimeSeries simulate(int size) {
        return TimeSeries.from(this.period, this.currentTime, this.getNext(size));
    }

    double[] getErrors() {
        return DoubleFunctions.arrayFrom(this.errors);
    }

    double[] getSeries() {
        return DoubleFunctions.arrayFrom(this.series);
    }

    double[] getDiffSeries() {
        return DoubleFunctions.arrayFrom(this.diffSeries);
    }

    public ArimaProcess startOver() {
        return ArimaProcess.builder().setCoefficients(this.coefficients).setDistribution(this.distribution).setPeriod(this.period).setSeasonalCycle(this.seasonalCycle).setStartTime(this.startTime).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArimaProcess that = (ArimaProcess)o;
        if (!this.coefficients.equals(that.coefficients)) {
            return false;
        }
        if (!this.distribution.equals(that.distribution)) {
            return false;
        }
        if (!this.period.equals(that.period)) {
            return false;
        }
        if (!this.seasonalCycle.equals(that.seasonalCycle)) {
            return false;
        }
        return this.startTime.equals(that.startTime);
    }

    public int hashCode() {
        int result = this.coefficients.hashCode();
        result = 31 * result + this.distribution.hashCode();
        result = 31 * result + this.period.hashCode();
        result = 31 * result + this.seasonalCycle.hashCode();
        result = 31 * result + this.startTime.hashCode();
        return result;
    }

    public String toString() {
        String nl = System.lineSeparator();
        return nl + "Arima Process: " + nl + "Coefficients: " + this.coefficients.toString() + nl + "Distribution: " + this.distribution.toString() + nl + "Period: " + this.period.toString() + nl + "Seasonal Cycle: " + this.seasonalCycle.toString() + nl + "Process Start: " + this.startTime.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ArimaCoefficients coefficients = ArimaCoefficients.builder().build();
        private Distribution distribution = new Normal();
        private TimePeriod period = this.coefficients.isSeasonal() ? TimePeriod.oneMonth() : TimePeriod.oneYear();
        private TimePeriod seasonalCycle = TimePeriod.oneYear();
        private OffsetDateTime startTime = OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        private boolean periodSet = false;

        public Builder setCoefficients(ArimaCoefficients coefficients) {
            this.coefficients = (ArimaCoefficients)Preconditions.checkNotNull((Object)coefficients, (Object)"The model coefficients cannot be null.");
            if (!this.periodSet) {
                this.period = coefficients.isSeasonal() ? TimePeriod.oneMonth() : TimePeriod.oneYear();
            }
            return this;
        }

        public Builder setDistribution(Distribution distribution) {
            this.distribution = (Distribution)Preconditions.checkNotNull((Object)distribution, (Object)"The distribution cannot be null.");
            return this;
        }

        public Builder setPeriod(TimePeriod period) {
            this.periodSet = true;
            this.period = (TimePeriod)Preconditions.checkNotNull((Object)period, (Object)"The time period cannot be null.");
            return this;
        }

        public Builder setSeasonalCycle(TimePeriod seasonalCycle) {
            this.seasonalCycle = (TimePeriod)Preconditions.checkNotNull((Object)seasonalCycle, (Object)"The seasonal cycle cannot be null.");
            return this;
        }

        public Builder setStartTime(OffsetDateTime startTime) {
            this.startTime = (OffsetDateTime)Preconditions.checkNotNull((Object)startTime, (Object)"The start time cannot be null.");
            return this;
        }

        public ArimaProcess build() {
            return new ArimaProcess(this);
        }
    }
}

