/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

final class ArmaStateSpace {
    private final double[] differencedSeries;
    private final double[] arParams;
    private final double[] maParams;
    private final double[][] transitionMatrix;
    private final double[] disturbanceVector;
    private final double[] observationVector;
    private final int r;

    ArmaStateSpace(double[] differencedSeries, double[] arParams, double[] maParams) {
        this.differencedSeries = (double[])differencedSeries.clone();
        this.arParams = (double[])arParams.clone();
        this.maParams = (double[])maParams.clone();
        this.r = Math.max(arParams.length, maParams.length + 1);
        this.transitionMatrix = this.createTransitionMatrix();
        this.disturbanceVector = this.createMovingAverageVector();
        this.observationVector = this.createStateEffectsVector();
    }

    private double[] createStateEffectsVector() {
        double[] Z = new double[this.r];
        Z[0] = 1.0;
        return Z;
    }

    private double[] createMovingAverageVector() {
        double[] R = new double[this.r];
        R[0] = 1.0;
        System.arraycopy(this.maParams, 0, R, 1, this.maParams.length);
        return R;
    }

    private double[][] createTransitionMatrix() {
        int i;
        double[][] T = new double[this.r][this.r];
        for (i = 0; i < this.arParams.length; ++i) {
            T[i][0] = this.arParams[i];
        }
        for (i = 1; i < this.r; ++i) {
            T[i - 1][i] = 1.0;
        }
        return T;
    }

    double[] differencedSeries() {
        return (double[])this.differencedSeries.clone();
    }

    double[] arParams() {
        return (double[])this.arParams.clone();
    }

    double[] maParams() {
        return (double[])this.maParams.clone();
    }

    final double[][] transitionMatrix() {
        return (double[][])this.transitionMatrix.clone();
    }

    final double[] movingAverageVector() {
        return (double[])this.disturbanceVector.clone();
    }

    final double[] stateEffectsVector() {
        return (double[])this.observationVector.clone();
    }

    final int r() {
        return this.r;
    }
}

