/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.regression;

import com.github.signaflo.data.regression.LinearRegressionPrediction;
import com.github.signaflo.data.regression.MultipleLinearRegressionPredictor;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.Vector;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecaster;
import com.github.signaflo.timeseries.model.regression.TimeSeriesRegressionForecast;
import java.time.OffsetDateTime;
import java.util.List;

class TimeSeriesRegressionForecaster
implements Forecaster {
    private final TimeSeries timeSeries;
    private final MultipleLinearRegressionPredictor predictor;
    private final Vector beta;
    private final Matrix predictionMatrix;

    TimeSeriesRegressionForecaster(TimeSeries timeSeries, MultipleLinearRegressionPredictor predictor, Vector beta, Matrix predictionMatrix) {
        this.timeSeries = timeSeries;
        this.predictor = predictor;
        this.beta = beta;
        this.predictionMatrix = predictionMatrix;
    }

    @Override
    public TimeSeries computePointForecasts(int steps) {
        double[] forecasts = this.predictionMatrix.times(this.beta).elements();
        TimePeriod timePeriod = this.timeSeries.timePeriod();
        OffsetDateTime sampleEnd = this.timeSeries.observationTimes().get(this.timeSeries.size() - 1);
        OffsetDateTime startTime = sampleEnd.plus(timePeriod.unitLength(), timePeriod.timeUnit().temporalUnit());
        return TimeSeries.from(timePeriod, startTime, forecasts);
    }

    @Override
    public TimeSeriesRegressionForecast forecast(int steps, double alpha) {
        TimeSeries forecast = this.computePointForecasts(steps);
        List<LinearRegressionPrediction> predictions = this.predictor.predictDesignMatrix(this.predictionMatrix, alpha);
        TimeSeries lowerBounds = this.computeLowerPredictionBounds(predictions, forecast, steps);
        TimeSeries upperBounds = this.computeUpperPredictionBounds(predictions, forecast, steps);
        return new TimeSeriesRegressionForecast(forecast, lowerBounds, upperBounds);
    }

    private TimeSeries computeLowerPredictionBounds(List<LinearRegressionPrediction> predictions, TimeSeries forecast, int steps) {
        double[] bounds = new double[steps];
        for (int i = 0; i < steps; ++i) {
            bounds[i] = predictions.get(i).predictionInterval().first();
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.startTime(), bounds);
    }

    private TimeSeries computeUpperPredictionBounds(List<LinearRegressionPrediction> predictions, TimeSeries forecast, int steps) {
        double[] bounds = new double[steps];
        for (int i = 0; i < steps; ++i) {
            bounds[i] = predictions.get(i).predictionInterval().second();
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.startTime(), bounds);
    }

    @Override
    public TimeSeries computeLowerPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        List<LinearRegressionPrediction> predictions = this.predictor.predictDesignMatrix(this.predictionMatrix, alpha);
        double[] bounds = new double[steps];
        for (int i = 0; i < steps; ++i) {
            bounds[i] = predictions.get(i).predictionInterval().first();
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.startTime(), bounds);
    }

    @Override
    public TimeSeries computeUpperPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        List<LinearRegressionPrediction> predictions = this.predictor.predictDesignMatrix(this.predictionMatrix, alpha);
        double[] bounds = new double[steps];
        for (int i = 0; i < steps; ++i) {
            bounds[i] = predictions.get(i).predictionInterval().second();
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.startTime(), bounds);
    }
}

