/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.operators;

import com.github.signaflo.timeseries.TimeSeries;
import java.time.OffsetDateTime;

public final class LagOperator {
    private LagOperator() {
    }

    public static double apply(TimeSeries series, int index) {
        return series.at(index - 1);
    }

    public static double apply(TimeSeries series, OffsetDateTime dateTime) {
        return series.at(series.dateTimeIndex().get(dateTime) - 1);
    }

    public static double apply(TimeSeries series, int index, int times) {
        return series.at(index - times);
    }

    public static double apply(TimeSeries series, OffsetDateTime dateTime, int times) {
        return series.at(series.dateTimeIndex().get(dateTime) - times);
    }

    public static double apply(double[] series, int index, int times) {
        return series[index - times];
    }
}

